/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#ifndef PROGRESSDIALOG_P_H
#define PROGRESSDIALOG_P_H

class ProgressDialog : public Dialog
{

    Q_PROPERTY(bool autoClose READ autoClose WRITE setAutoClose)
    Q_PROPERTY(int minimum READ minimum WRITE setMinimum)
    Q_PROPERTY(int maximum READ maximum WRITE setMaximum)
    Q_PROPERTY(int value READ value WRITE setValue)
    Q_PROPERTY(string labelText READ labelText WRITE setLabelText)
    Q_PROPERTY(string cancelButtonText READ cancelButtonText WRITE setCancelButtonText)
    
public:
    void cancel();
    void reset();
    
signals:
    void canceled();
    
/*!
    \class ProgressDialog
    \brief The ProgressDialog component displays the progress of an ongoing operation
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-dialogs
    
    A progress dialog is used to give the user an indication of how long
    an operation is going to take, and to demonstrate that the
    application has not frozen. It can also give the user an opportunity
    to abort the operation.
    
    \code
    Window {
        id: window
        
        Button {
            anchors.centerIn: parent
            text: "Start operation"
            onClicked: progressDialog.open()
        }
        
        ProgressDialog {
            id: progressDialog
            
            windowTitle: "Please wait"
            labelText: "This is an ongoing operation"
            maximum: 10
            onCanceled: reset()
        }
        
        Timer {
            id: timer
            
            interval: 1000
            repeat: true
            running: progressDialog.visible
            onTriggered: progressDialog.value++
        }
    }
    \endcode
*/

/*!
    \property bool ProgressDialog::autoClose
    \brief Whether the dialog should close when reset() is called
*/

/*!
    \property int ProgressDialog::minimum
    \brief The minimum value of the progress bar
    
    \sa ProgressBar::minimum
*/

/*!
    \property int ProgressDialog::maximum
    \brief The maximum value of the progress bar
    
    \sa ProgressBar::maximum
*/

/*!
    \property int ProgressDialog::value
    \brief The current value of the progress bar
    
    \sa ProgressBar::value
*/

/*!
    \property string ProgressDialog::labelText
    \brief The text of the message label
    
    \sa Label::text
*/

/*!
    \property string ProgressDialog::cancelButtonText
    \brief The text of the cancel button
    
    \sa Button::text
*/

/*!
    \fn void ProgressDialog::cancel()
    
    Cancels the dialog.
*/

/*!
    \fn void ProgressDialog::reset()
    
    Resets the dialog and the progress bar.
    
    \sa ProgressBar::reset()
*/

/*!
    \fn void ProgressDialog::canceled()
    
    This signal is emitted when the dialog is canceled.
*/

};

#endif // PROGRESSDIALOG_P_H
