/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PROGRESSBARSTYLE_P_H
#define PROGRESSBARSTYLE_P_H

class ProgressBarStyle : public Style
{
    
    Q_PROPERTY(Style chunk READ chunk WRITE setChunk)
    Q_PROPERTY(flags textAlignment READ textAlignment WRITE setTextAlignment)
    
/*!
    \class ProgressBarStyle
    \brief ProgressBarStyle is a styling component for ProgressBar
    
    \ingroup org-hidon-components
    \ingroup org-hildon-components-style
    
    The ProgressBarStyle component provides styling properties 
    that are applied to any ProgressBar which has its style property 
    set to the particular ButtonStyle instance.
    
    \code
    ProgressBar {
        style: ProgressBarStyle {
            textAlignment: Qt.AlignLeft
        }
    }
    \endcode
    
    \sa ProgressBar
*/

/*!
    \property Style ProgressBarStyle::chunk
    \brief The Style applied to the chunks of the progress bar
    
    Setting this property to a Style will apply the style's 
    properties to each chunk of the progress bar.
    
    \code
    ProgressBar {
        style: ProgressBarStyle {
            chunk: Style {
                backgroundColor: "red"
            }
        }
    }
    \endcode
*/

/*!
    \propertys flag ProgressBarStyle::textAlignment
    \brief Aligns the ProgressBar's text.
    
    Available flags are:
    
    \li \c Qt.AlignLeft
    \li \c Qt.AlignRight
    \li \c Qt.AlignHCenter
    \li \c Qt.AlignTop
    \li \c Qt.AlignBottom
    \li \c Qt.AlignVCenter
    \li \c Qt.AlignCenter
*/

};

#endif // PROGRESSBARSTYLE_P_H

