/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PLATFORMSTYLE_P_H
#define PLATFORMSTYLE_P_H

class PlatformStyle
{

    Q_PROPERTY(int paddingSmall READ paddingSmall CONSTANT)
    Q_PROPERTY(int paddingMedium READ paddingMedium CONSTANT)
    Q_PROPERTY(int paddingLarge READ paddingLarge CONSTANT)
    Q_PROPERTY(int fontSizeSmall READ fontSizeSmall CONSTANT)
    Q_PROPERTY(int fontSizeMedium READ fontSizeMedium CONSTANT)
    Q_PROPERTY(int fontSizeLarge READ fontSizeLarge CONSTANT)
    Q_PROPERTY(color defaultTextColor READ defaultTextColor CONSTANT)
    Q_PROPERTY(color secondaryTextColor READ secondaryTextColor CONSTANT)
    Q_PROPERTY(color activeTextColor READ activeTextColor CONSTANT)
    Q_PROPERTY(color disabledTextColor READ disabledTextColor CONSTANT)
    Q_PROPERTY(color paintedTextColor READ paintedTextColor CONSTANT)
    Q_PROPERTY(color reversedTextColor READ reversedTextColor CONSTANT)
    Q_PROPERTY(color reversedSecondaryTextColor READ reversedSecondaryTextColor CONSTANT)
    Q_PROPERTY(color reversedActiveTextColor READ reversedActiveTextColor CONSTANT)
    Q_PROPERTY(color reversedDisabledTextColor READ reversedDisabledTextColor CONSTANT)
    Q_PROPERTY(color reversedPaintedTextColor READ reversedPaintedTextColor CONSTANT)
    Q_PROPERTY(color defaultBackgroundColor READ defaultBackgroundColor CONSTANT)
    Q_PROPERTY(color darkerBackgroundColor READ darkerBackgroundColor CONSTANT)
    Q_PROPERTY(color reversedBackgroundColor READ reversedBackgroundColor CONSTANT)
    Q_PROPERTY(color selectionColor READ selectionColor CONSTANT)
    Q_PROPERTY(color reversedSelectionColor READ reversedSelectionColor CONSTANT)
    Q_PROPERTY(color contentBackgroundColor READ contentBackgroundColor CONSTANT)
    Q_PROPERTY(color contentFrameColor READ contentFrameColor CONSTANT)
    Q_PROPERTY(color contentSelectionColor READ contentSelectionColor CONSTANT)
    Q_PROPERTY(color titleTextColor READ titleTextColor CONSTANT)
    Q_PROPERTY(color buttonTextColor READ buttonTextColor CONSTANT)
    Q_PROPERTY(color buttonTextPressedColor READ buttonTextPressedColor CONSTANT)
    Q_PROPERTY(color buttonTextDisabledColor READ buttonTextDisabledColor CONSTANT)
    Q_PROPERTY(color accentColor1 READ accentColor1 CONSTANT)
    Q_PROPERTY(color accentColor2 READ accentColor2 CONSTANT)
    Q_PROPERTY(color accentColor3 READ accentColor3 CONSTANT)
    Q_PROPERTY(color attentionColor READ attentionColor CONSTANT)
    Q_PROPERTY(color notificationBackgroundColor READ notificationBackgroundColor CONSTANT)
    Q_PROPERTY(color notificationTextColor READ notificationTextColor CONSTANT)
    Q_PROPERTY(color notificationSecondaryTextColor READ notificationSecondaryTextColor CONSTANT)

/*!
    \class PlatformStyle
    \brief PlatformStyle is a global context property providing styling constants
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-properties
    
    The PlatformStyle object is accessible as a global 
    context property (named 'platformStyle') in QML, and provides a number of 
    styling constants that can be used to ensure that an 
    application adheres to the Maemo5 Hildon style guidelines:
    
    \code
    Label {
        text: "Hello world!"
        color: platformStyle.activeTextColor
    }
    \endcode
    
    \note PlatformStyle is a context property and cannot be created in QML.
    
    \sa Style
*/

/*!
    \property int PlatformStyle::paddingSmall
    \brief The small padding value
*/

/*!
    \property int PlatformStyle::paddingMedium
    \brief The medium padding value
*/

/*!
    \property int PlatformStyle::paddingLarge
    \brief The large padding value
*/

/*!
    \property int PlatformStyle::fontSizeSmall
    \brief The small font size in pixels
*/

/*!
    \property int PlatformStyle::fontSizeMedium
    \brief The medium font size in pixels
*/

/*!
    \property int PlatformStyle::fontSizeLarge
    \brief The large font size in pixels
*/

/*!
    \property color PlatformStyle::defaultTextColor
    \brief The default text color used in Label etc
*/

/*!
    \property color PlatformStyle::secondaryTextColor
    \brief The secondary text color
*/

/*!
    \property color PlatformStyle::activeTextColor
    \brief The active text color used for highlighting
*/

/*!
    \property color PlatformStyle::disabledTextColor
    \brief The default text color used in disabled items
*/

/*!
    \property color PlatformStyle::paintedTextColor
    \brief The painted text color
*/

/*!
    \property color PlatformStyle::reversedTextColor
    \brief The text color contrasting with defaultTextColor
*/

/*!
    \property color PlatformStyle::reversedSecondaryTextColor
    \brief The text color contrasting with secondaryTextColor
*/

/*!
    \property color PlatformStyle::reversedActiveTextColor
    \brief The text color contrasting with activeTextColor
*/

/*!
    \property color PlatformStyle::reversedDisabledTextColor
    \brief The text color contrasting with disabledTextColor
*/

/*!
    \property color PlatformStyle::reversedPaintedTextColor
    \brief The text color contrasting with paintedTextColor
*/

/*!
    \property color PlatformStyle::defaultBackgroundColor
    \brief The default color for item backgrounds
*/

/*!
    \property color PlatformStyle::darkerBackgroundColor
    \brief The darker color for item backgrounds
*/

/*!
    \property color PlatformStyle::reversedBackgroundColor
    \brief The background color contrasting with defaultBackgroundColor
*/

/*!
    \property color PlatformStyle::selectionColor
    \brief The color for selected items
*/

/*!
    \property color PlatformStyle::reversedSelectionColor
    \brief The color contrasting with selectionColor
*/

/*!
    \property color PlatformStyle::contentBackgroundColor
    \brief The background color for item content
*/

/*!
    \property color PlatformStyle::contentFrameColor
    \brief The frame color for item content
*/

/*!
    \property color PlatformStyle::contentSelectionColor
    \brief The color for selected item content
*/

/*!
    \property color PlatformStyle::titleTextColor
    \brief The color for window titles
*/

/*!
    \property color PlatformStyle::buttonTextColor
    \brief The color for button text
*/

/*!
    \property color PlatformStyle::buttonTextPressedColor
    \brief The color for button text when the button is pressed
*/

/*!
    \property color PlatformStyle::buttonTextDisabledColor
    \brief The color for button text when the button is disabled
*/

/*!
    \property color PlatformStyle::accentColor1
    \brief The first accent color
*/

/*!
    \property color PlatformStyle::accentColor2
    \brief The second accent color
*/

/*!
    \property color PlatformStyle::accentColor3
    \brief The third accent color
*/

/*!
    \property color PlatformStyle::attentionColor
    \brief The attention color
*/

/*!
    \property color PlatformStyle::notificationBackgroundColor
    \brief The background color for notification banners
*/

/*!
    \property color PlatformStyle::notificationTextColor
    \brief The text color for notification banners
*/

/*!
    \property color PlatformStyle::notificationSecondaryTextColor
    \brief The secondary text color for notification banners
*/

};

#endif // PLATFORMSTYLE_P_H
