/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PAGE_P_H
#define PAGE_P_H

class Page : public Item
{

    Q_PROPERTY(enumeration orientationLock READ orientationLock WRITE setOrientationLock)
    Q_PROPERTY(bool inPortrait READ inPortrait)
    Q_PROPERTY(bool fullScreen READ isFullScreen WRITE setFullScreen)
    Q_PROPERTY(bool showProgressIndicator READ showingProgressIndicator WRITE showProgressIndicator)
    Q_PROPERTY(bool autoClose READ autoClose WRITE setAutoClose)
    Q_PROPERTY(list<Object> tools READ tools)

signals:
    void closeRequest();

/*!
    \class Page
    \brief The Page component provides an item in the application window's PageStack
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls
    
    Each Window in an application has a pageStack property. The PageStack 
    is a stack of pages, each of which represents a screen in the application. 
    The Page component is essentially a container in which other visual items 
    are displayed:
    
    \code
    Page {
        id: page
        
        Label {
            anchors.fill: parent
            alignment: Qt.AlignCenter
            text: "Hello world!"
        }
    }
    \endcode
    
    \sa PageStack, Window
*/

/*!
    \property enumeration Page::orientationLock
    \brief The allowed orientation(s) of the page
    
    Possible values are:
    
    \li \c Screen.LandscapeOrientation - The page is locked to landscape.
    \li \c Screen.PortraitOrientation - The page is locked to portrait.
    \li \c Screen.AutoOrientation - The page's orientation changes when 
    the device is rotated.
    
    The default value is \c Screen.LandscapeOrientation.
    
    \sa Screen
*/

/*!
    \property bool Page::inPortrait
    \brief Whether the page's orientation is \c Screen.PortraitOrientation
    
    \sa orientationLock
*/

/*!
    \property bool Page::fullScreen
    \brief Whether the page is displayed in fullScreen
    
    The default value is \a false.
*/

/*!
    \property bool Page::showProgressIndicator
    \brief Whether the progress indicator is visible
    
    The default value is \a false.
*/

/*!
    \property bool Page::autoClose
    \brief Whether the page should close automatically when 
    the 'back' button is clicked
    
    If this property is set to \a false, the closeRequest() 
    signal will be emitted when the 'back' button is clicked.
    
    \sa closeRequest()
*/

/*!
    \property list<Object> Page::tools
    \brief The page's tools that appear in the menu
    
    Actions assigned to the page's tools will appear in 
    the menu. Adding an ActionGroup with child actions 
    will add a filter group to the menu.
    
    \sa Action, ActionGroup
*/

/*!
    \fn void Page::closeRequest()
    
    This signal is emitted when the 'back' button 
    is pressed and the autoClose property is set to 
    \a false.
    
    \sa autoClose
*/

};

#endif // PAGE_P_H
