/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MULTILISTSELECTOR_P_H
#define MULTILISTSELECTOR_P_H

class MultiListSelector
{

    Q_PROPERTY(variant model READ model WRITE setModel)
    Q_PROPERTY(int modelColumn READ modelColumn WRITE setModelColumn)
    Q_PROPERTY(list<int> currentIndexes READ currentIndexes WRITE setCurrentIndexes)
    Q_PROPERTY(string currentValueText READ currentValueText)

signals:
    void selected(string text);

/*!
    \class MultiListSelector
    \brief The MultiListSelector component provides a list selection dialog for use with a ValueButton
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-dialogs
    
    Assigning a MultiListSelector to the selector property of a ValueButton 
    enables the user to select from the items in the selector's model:
    
    \code
     ValueButton {
        id: button

        text: "Selected value"
        selector: MultiListSelector {
            model: 10
            onSelected: console.log("Values selected: " + text)
        }
    }
    \endcode
    
    \sa ListSelector, ListModel, ValueButton
*/

/*!
    \property variant MultiListSelector::model
    \brief The model used to display items in the selector
    
    The model can be any of the following types:
    
    \li \c int
    \li \c string
    \li \c list
    \li \c stringlist
    \li \c ListModel
    \li \c QAbstractItemModel
    
    \sa modelColumn
*/

/*!
    \property int MultiListSelector::modelColumn
    \brief The column used to display items in the selector
    
    The default value is 0, and should only be changed if neccessary 
    when using a QAbstractItemModel.
    
    \sa model
*/

/*!
    \property list<int> MultiListSelector::currentIndexes
    \brief The indexes of the currently selected items
    
    \sa currentValueText
*/

/*!
    \property string MultiListSelector::currentValueText
    \brief The text of the currently selected items
    
    \sa currentIndexes
*/

/*!
    \fn void MultiListSelector::selected(string text)
    
    This signal is emitted when the user selects some items 
    in the selector. The \a text passed is the 
    same as currentValueText.
    
    \sa currentValueText
*/

};

#endif // MULTILISTSELECTOR_P_H
