/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MENU_P_H
#define MENU_P_H

class Menu : public Item
{

    Q_PROPERTY(bool tearOffEnabled READ isTearOffEnabled WRITE setTearOffEnabled)
    Q_PROPERTY(string title READ title WRITE setTitle)
    Q_PROPERTY(string icon READ icon WRITE setIcon)
    Q_PROPERTY(bool separatorsCollapsible READ separatorsCollapsible WRITE setSeparatorsCollapsible)
    
public:
    void open(point p, Action atAction = null);
    
signals:
    void aboutToShow();
    void aboutToHide();
    void triggered(Action action);

/*!
    \class Menu
    \brief The Menu component provides a menu for use in menu
    bars, context menus, and other popup menus.

    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls
*/

/*!
    \property bool Menu::tearOffEnabled
    \brief Whether the menu supports being torn off

    When true, the menu contains a special tear-off item (often shown as a dashed
    line at the top of the menu) that creates a copy of the menu when it is
    triggered.

    This "torn-off" copy lives in a separate window. It contains the same menu
    items as the original menu, with the exception of the tear-off handle.

    By default, this property is false.
*/

/*!
    \property bool Menu::separatorsCollapsible

    \brief Whether consecutive separators should be collapsed

    This property specifies whether consecutive separators in the menu
    should be visually collapsed to a single one. Separators at the
    beginning or the end of the menu are also hidden.

    By default, this property is true.
*/

/*!
    \property string Menu::title
    \brief The title of the menu

    By default, this property contains an empty string.
*/

/*!
    \property string Menu::icon

    \brief The icon source of the menu

    By default, if no icon is explicitly set, this property contains an empty string.
*/

/*!
    \fn void Menu::open(point p, Action atAction = null)
    
    Displays the menu so that the action \a atAction will be at the
    specified \e global position \a p.
*/

/*!
    \fn void Menu::aboutToHide()

    This signal is emitted just before the menu is hidden from the user.

    \sa aboutToShow()
*/

/*!
    \fn void Menu::aboutToShow()

    This signal is emitted just before the menu is shown to the user.

    \sa aboutToHide()
*/

/*!
    \fn void Menu::triggered(Action action)

    This signal is emitted when an action in this menu is triggered.

    \a action is the action that caused the signal to be emitted.

    Normally, you connect each menu action's Action::triggered() signal
    to its own custom slot, but sometimes you will want to connect several
    actions to a single slot, for example, when you have a group of closely
    related actions, such as "left justify", "center", "right justify".

    \note This signal is emitted for the main parent menu in a hierarchy.
    Hence, only the parent menu needs to be connected to a slot; sub-menus need
    not be connected.

    \sa Action::triggered()
*/

};


#endif // MENU_P_H
