/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LISTMODEL_P_H
#define LISTMODEL_P_H

class ListModel
{

    Q_PROPERTY(int count READ rowCount)

public:
    QModelIndex modelIndex(int row, int column = 0, QModelIndex parent = QModelIndex());

    variant property(QModelIndex index, string name);

    void setProperty(QModelIndex index, QString name, variant value);

    ListElement get(QModelIndex index);

    void set(QModelIndex index, jsobject properties);

    void append(jsobject properties);

    void insert(QModelIndex index, jsobject properties);

    void move(ModelIndex fromIndex, QModelIndex toIndex, int count);

    void remove(QModelIndex index);

    void clear();

/*!
    \class ListModel
    \brief The ListModel component provides a data model representing a flat list
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-data
    
    \include ListViewWithCustomDelegate.qml
    
    \sa ListElement, ListView
*/

/*!
    \property int ListModel::count
    \brief The number of items in the model
*/

/*!
    \fn QModelIndex ListModel::modelIndex(int row, int column = 0,
                                          QModelIndex parent = QModelIndex())
                                          
    Returns the QModelIndex at the given \a row and \a column, 
    with parent QModelIndex \a parent.
*/

/*!
    \fn variant ListModel::property(QModelIndex index, string name)
    
    Returns the value of the property at the given \a index 
    with role name \a name.
*/

/*!
    \fn void setProperty(QModelIndex index, QString name, variant value)
    
    Sets the value of the property at the given \a index with role name \a name 
    to \a value.
*/

/*!
    \fn ListElement ListModel::get(QModelIndex index)
    
    Returns the item at the given \a index, if \a index is valid.
*/

/*!
    \fn void ListModel::set(QModelIndex index, jsobject properties)
    
    Sets the properties at the given \a index to those in \a properties. 
    Properties not in \a properties are left unchanged.
*/

/*!
    \fn void ListModel::append(jsobject properties)
    
    Appends a new item to the model with the given \a properties.
*/

/*!
    \fn void ListModel::insert(QModelIndex index, jsobject properties)
    
    Inserts a new item into the model before \a index with the 
    given \a properties.
*/

/*!
    \fn void ListModel::move(QModelIndex fromIndex, QModelIndex toIndex, int count)
    
    Moves \a count items starting at \a fromIndex to \a toIndex.
*/

/*!
    \fn void ListModel::remove(QModelInde index)
    
    Removes the item at \a index.
*/

/*!
    \fn void ListModel::clear()
    
    Removes all items from the model.
*/

};

#endif // LISTMODEL_P_H
