/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LISTITEMBORDERIMAGE_P_H
#define LISTITEMBORDERIMAGE_P_H

class ListItemBorderImage: public ListItemContent
{
    
    Q_PROPERTY(url source READ source WRITE setSource)
    Q_PROPERTY(bool asynchronous READ asynchronous WRITE setAsynchronous)
    Q_PROPERTY(bool cache READ cache WRITE setCache)
    Q_PROPERTY(bool mirror READ mirror WRITE setMirror)
    Q_PROPERTY(bool smooth READ smooth WRITE setSmooth)
    Q_PROPERTY(real progress READ progress)
    Q_PROPERTY(enumeration status READ status)
    Q_PROPERTY(int border READ border WRITE setBorder)
    Q_PROPERTY(enumeration horizontalTileMode READ horizontalTileMode WRITE setHorizontalTileMode)
    Q_PROPERTY(enumeration verticalTileMode READ verticalTileMode WRITE setVerticalTileMode)
    Q_PROPERTY(size sourceSize READ sourceSize)

/*!
    \class ListItemBorderImage
    \brief The ListItemBorderImage component displays a border image in ListItem
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-graphics
    \ingroup org-hildon-components-views
    
    \sa ListItem, BorderImage
*/

/*!
    \property url ListItemBorderImage::source
    
    This property holds the URL that refers to the source image.
    ListItemBorderImage can handle any image format supported by Qt, loaded from any
    URL scheme supported by Qt.

    The URL may be absolute, or relative to the URL of the component.
*/

/*!
    \property size ListItemBorderImage::sourceSize
    
    This property holds the actual width and height of the loaded image.
    In ListItemBorderImage, this property is read-only.
    
    \sa Image::sourceSize
*/

/*!
    \property bool ListItemBorderImage::asynchronous
    
    Specifies that images on the local filesystem should be loaded
    asynchronously in a separate thread. The default value is
    false, causing the user interface thread to block while the
    image is loaded. Setting \a asynchronous to true is useful where
    maintaining a responsive user interface is more desirable
    than having images immediately visible.
    
    Note that this property is only valid for images read from the
    local filesystem. Images loaded via a network resource (e.g. HTTP)
    are always loaded asynchonously.
*/

/*!
    \property bool ListItemBorderImage::cache

    Specifies whether the image should be cached. The default value is
    true. Setting \a cache to false is useful when dealing with large images,
    to make sure that they aren't cached at the expense of small 'ui element' images.
*/

/*!
    \property bool ListItemBorderImage::mirror

    This property holds whether the image should be horizontally inverted
    (effectively displaying a mirrored image).
    
    The default value is false.
*/

/*!
    \property bool ListItemBorderImage::smooth
    
    Set this property if you want the image to be smoothly filtered when scaled or
    transformed. Smooth filtering gives better visual quality, but is slower. If
    the image is displayed at its natural size, this property has no visual or
    performance effect.
    
    By default, this property is set to false.
    
    \note Generally scaling artifacts are only visible if the image is stationary on
    the screen. A common pattern when animating an image is to disable smooth
    filtering at the beginning of the animation and enable it at the conclusion.
*/

/*!
    \property real ListItemBorderImage::progress
    
    This property holds the progress of image loading, from 0.0 (nothing loaded)
    to 1.0 (finished).
    
    \sa status
*/

/*!
    \property enumeration ListItemBorderImage::status
    
    This property describes the status of image loading. It can be one of:

    \li \c ListItemBorderImage.Null - no image has been set
    \li \c ListItemBorderImage.Ready - the image has been loaded
    \li \c ListItemBorderImage.Loading - the image is currently being loaded
    \li \c ListItemBorderImage.Error - an error occurred while loading the image

    \sa progress
*/

/*!
    \property enumeration ListItemBorderImage::horizontalTileMode
    
    This property describes how to repeat or stretch the middle parts of the border image.
    
    \li \c ListItemBorderImage.Stretch - Scales the image to fit to the available area.
    \li \c ListItemBorderImage.Repeat - Tile the image until there is no more space. May crop the last image.
    \li \c ListItemBorderImage.Round - Like Repeat, but scales the images down to ensure that the last image is not cropped.
    
    The default tile mode ListItemBorderImage.Stretch.
*/

/*!
    \property enumeration ListItemBorderImage::verticalTileMode
    
    This property describes how to repeat or stretch the middle parts of the border image.
    
    \li \c ListItemBorderImage.Stretch - Scales the image to fit to the available area.
    \li \c ListItemBorderImage.Repeat - Tile the image until there is no more space. May crop the last image.
    \li \c ListItemBorderImage.Round - Like Repeat, but scales the images down to ensure that the last image is not cropped.
    
    The default tile mode is ListItemBorderImage.Stretch.
*/

/*!
    \property int ListItemBorderImage::border
    
    The 4 border lines (2 horizontal and 2 vertical) break the image into 9 sections.
    Each border line (left, right, top, and bottom) specifies an offset in pixels
    from the respective edge of the source image. By default, each border line has
    a value of 0.
*/

};

#endif // LISTITEMBORDERIMAGE_P_H
