/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef INFORMATIONBOX_P_H
#define INFORMATIONBOX_P_H

class InformationBox : public Dialog
{

    Q_PROPERTY(int timeout READ timeout WRITE setTimeout)
    
signals:
    void clicked();
    
/*!
    \class InformationBox
    \brief The InformationBox component provides Hildon Banners and Notes
    for informing the user.
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-dialogs
    
    This component is used to display an arbitrary item with or without a 
    timeout to alert the user to a situation.
    
    Information boxes that have a timeout will show as Hildon Banners, which
    will be hidden after the specified time. In the case where \c NoTimeout
    is specified for the timeout value, the information box will show up as a
    Hildon Note, which has to be acknowledged by the user with a tap anywhere
    on the screen.
    
    The \link content \endlink property is used to determine what appears in 
    the information box:
    
    \code
    InformationBox {
        content: Label {
            anchors.fill: parent
            alignment: Qt.AlignCenter
            text: "This is a Hildon Banner"
        }
    
        Component.onCompleted: open()
    }
    \endcode
*/

/*!
    \property int InformationBox::timeout
    \brief The timeout after which the informaton box should automatically be
    hidden.
    
    Setting this value while the box is already visible will reset its timer.
    
    The timeout value can be specified as an arbitrary millisecond value,
    although it is recommended to use the predefined values \c NoTimeout (for
    Hildon Notes) and \c DefaultTimeout (for style guide compliant Banners).
    
    The default value of this property is \c DefaultTimeout (3 seconds).
    The maximum timeout is 10 seconds.
*/

/*!
    \fn void InformationBox::clicked()
    
    This signal is emitted whenever the information box is clicked.
*/

};

#endif // INFORMATIONBOX_P_H
