/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef GRID_P_H
#define GRID_P_H

class Grid : public Item
{
    Q_OBJECT

    Q_PROPERTY(int columns READ columns WRITE setColumns)
    Q_PROPERTY(int spacing READ spacing WRITE setSpacing)
    Q_PROPERTY(int horizontalSpacing READ horizontalSpacing WRITE setHorizontalSpacing)
    Q_PROPERTY(int verticalSpacing READ verticalSpacing WRITE setVerticalSpacing)

/*!
    \class Grid
    \brief The Grid component provides a grid layout for 
    visual items

    \ingroup org-hildon-components
    \ingroup org-hildon-components-positioning
    
    Visual items declared as children of the Grid are automatically 
    added to the layout:
    
    \code
    Grid {
        columns: 2
        
        Button {
            text: "Button one"
        }
        
        Button {
            text: "Button two"
        }
        
        Button {
            text: "Button three"
        }
        
        Button {
            text: "Button four"
        }
    }
    \endcode
*/

/*!
    \property int Grid::columns
    
    Determines the number of columns 
    in the layout.
*/

/*!
    \property int Grid::spacing
    
    Determines the spacing between items 
    in the layout.
*/

/*!
    \property int Grid::horizontalSpacing
    
    Determines the horizontal spacing between items 
    in the layout.
*/

/*!
    \property int Grid::verticalSpacing
    
    Determines the vertical spacing between items 
    in the layout.
*/

};

#endif // GRID_P_H
