/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef DATESELECTOR_P_H
#define DATESELECTOR_P_H

class DateSelector
{

    Q_PROPERTY(int minimumYear READ minimumYear WRITE setMinimumYear)
    Q_PROPERTY(int maximumYear READ maximumYear WRITE setMaximumYear)
    Q_PROPERTY(date currentDate READ currentDate WRITE setCurrentDate)
    Q_PROPERTY(string currentValueText READ currentValueText)

signals:
    void selected(string text);

/*!
    \class DateSelector
    \brief The DateSelector component is a date selector for use with 
    the ValueButton component

    \ingroup org-hildon-components
    \ingroup org-hildon-components-dialogs
    
    When the ValueButton is clicked, the DateSelector dialog will be shown, 
    allowing the user to choose a date value. The valueText property of 
    the ValueButton will be updated accordingly.
    
    \code
     ValueButton {
        id: button

        text: "Selected date"
        selector: DateSelector {
            onSelected: console.log("Value selected: " + text)
        }
    }
    \endcode
    
    \sa ValueButton
*/

/*!
    \property date DateSelector::currentDate
    
    The date currently selected. This can also be 
    changed programmatically.
*/

/*!
    \property int DateSelector::minimumYear
    
    The minimum year to be displayed in the selection dialog.
*/

/*!
    \property int DateSelector::maximumYear
    
    The maximum year to be displayed in the selection dialog.
*/

/*!
    \property string DateSelector::currentValueText
    
    The currently selected date formatted as a string.
*/

/*!
    \fn void DateSelector::selected(string text)
    
    This signal is emitted when the user selects the date. 
    The \a text passed is the same as currentValueText.
    
    \sa currentValueText
*/

};

#endif // DATESELECTOR_P_H
