/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef CONNECTIONS_H
#define CONNECTIONS_H

class Connections
{

    Q_PROPERTY(Object target READ target WRITE setTarget)
    Q_PROPERTY(bool ignoreUnknownSignals READ ignoreUnknownSignals WRITE setIgnoreUnknownSignals)

/*!
    \class Connections
    \brief The Connections component describes generalized connections to signals.
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-utility

    When connecting to signals in QML, the usual way is to create an
    "on<Signal>" handler that reacts when a signal is received, like this:

    \code
    MouseArea {
        onClicked: { foo(parameters) }
    }
    \endcode

    However, it is not possible to connect to a signal in this way in some 
    cases, such as when:

    \li Multiple connections to the same signal are required
    \li Creating connections outside the scope of the signal sender
    \li Connecting to targets not defined in QML

    When any of these are needed, the Connections component can be used instead.

    For example, the above code can be changed to use a Connections component,
    like this:

    \code
    MouseArea {
        Connections {
            onClicked: foo(parameters)
        }
    }
    \endcode

    More generally, the Connections component can be a child of some object other than
    the sender of the signal:

    \code
    MouseArea {
        id: area
    }
    // ...
    \endcode
    
    \code
    Connections {
        target: area
        onClicked: foo(parameters)
    }
    \endcode
*/

/*!
    \property Object Connections::target
    This property holds the object that sends the signal.

    If this property is not set, the \c target defaults to the parent of the Connection.

    If set to null, no connection is made and any signal handlers are ignored
    until the target is not null.
*/

/*!
    \property bool Connections::ignoreUnknownSignals

    Normally, a connection to a non-existent signal produces runtime errors.

    If this property is set to \c true, such errors are ignored.
    This is useful if you intend to connect to different types of objects, handling
    a different set of signals for each object.
*/

};

#endif // CONNECTIONS_H
