/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef CHECKBOXSTYLE_P_H
#define CHECKBOXSTYLE_P_H

class CheckBoxStyle : public ButtonStyle
{

    Q_PROPERTY(int spacing READ spacing WRITE setSpacing)
    
/*!
    \class CheckBoxStyle
    \brief CheckBoxStyle is a styling component for CheckBox

    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    The CheckBoxStyle component provides styling properties that 
    are applied to any CheckBox which has its style property 
    set to the particular CheckBoxStyle instance.
*/

/*!
    \property int CheckBoxStyle::spacing
    
    Determines the spacing between the indicator and the text 
    of the CheckBox.
*/

};

#endif // CHECKBOXSTYLE_P_H
