/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef BUTTONSTYLE_P_H
#define BUTTONSTYLE_P_H

class ButtonStyle : public Style
{
    
    Q_PROPERTY(Style indicator READ indicator WRITE setIndicator)
    Q_PROPERTY(flags textAlignment READ textAlignment WRITE setTextAlignment)

/*!
    \class ButtonStyle
    \brief ButtonStyle is a styling component for Button
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    The ButtonStyle component provides styling properties that 
    are applied to any Button which has its style property 
    set to the particular ButtonStyle instance.
    
    \sa Button
*/

/*!
    \property Style ButtonStyle::indicator
    \brief The style to be applied to the Button's indicator.
    
    Setting this property to a Style component will apply the Style's 
    properties to the Button's indicator. Setting the property to 
    undefined will reset the Style and remove any style properties applied.
*/

/*!
    \property flags ButtonStyle::textAlignment
    \brief Aligns the Button's text.
    
    Avalilable flags are:
    
    \li \c Qt.AlignLeft
    \li \c Qt.AlignRight
    \li \c Qt.AlignHCenter
    \li \c Qt.AlignTop
    \li \c Qt.AlignBottom
    \li \c Qt.AlignVCenter
    \li \c Qt.AlignCenter
*/

};

#endif // BUTTONSTYLE_P_H

