import QtQuick 1.0
import "Utils.js" as Utils

Item {
    id: root

    property Item tools: null
    property Style platformStyle: ToolBarStyle {}

    height: 70
    anchors {
        left: parent.left
        right: parent.right
        bottom: parent.bottom
    }
    onToolsChanged: if (tools) tools.parent = root;

    Loader {
        id: loader

        anchors.fill: parent
        sourceComponent: platformStyle.background === "" ? background : backgroundImage
    }

    Component {
        id: background

        Rectangle {
            anchors.fill: parent
            color: "black"
        }
    }

    Component {
        id: backgroundImage

        Image {
            anchors.fill: parent
            smooth: true
            fillMode: Image.Stretch
            source: platformStyle.background
        }
    }

    MouseArea {
        z: -1
        anchors.fill: parent
    }
}
