import QtQuick 1.0

FocusScope {
    id: root

    property string title
    property bool fullScreen: false
    property Item tools: null

    anchors.fill: !parent ? undefined : parent
    onToolsChanged: if (tools) tools.parent = root; // Make sure that the page owns the tools
    visible: (pageStack !== null) && (pageStack.currentPage === root)
    focus: visible

    MouseArea {
        anchors.fill: parent
        onClicked: root.focus = true
    }
}
