import QtQuick 1.0

Column {
    id: root

    property Style platformStyle: Style {}

    function closeLayout() {
        parent.close();
    }

    QtObject {
        id: internal

        function update() {
            root.parent.width = root.childrenRect.width + platformStyle.paddingNormal * 2;
            root.parent.height = root.height + platformStyle.paddingNormal * 2;

            for (var i = 0; i < root.children.length; i++) {
                root.children[i].width = root.childrenRect.width;
            }
        }
    }

    anchors {
        top: parent.top
        left: parent.left
        right: parent.right
        margins: platformStyle.paddingNormal
    }

    Component.onCompleted: internal.update()
}
