import QtQuick 1.0
import "Utils.js" as Utils

Popup {
    id: root

    z: -1
    objectName: "__contextMenu"
    enabled: visible

    Component.onCompleted: internal.globalMouseArea = Utils.findGlobalMouseArea(root)

    QtObject {
        id: internal

        property MouseArea globalMouseArea: null

        function updatePosition() {
            x = Math.min(globalMouseArea.mouseX, globalMouseArea.width - width);
            y = Math.min(Math.abs(globalMouseArea.mouseY - height / 2), globalMouseArea.height - height);
        }
    }

    Connections {
        target: internal.globalMouseArea
        onPressed: if (root.z < 0) internal.updatePosition();
    }

    BorderImage {
        id: background

        anchors.fill: parent
        smooth: true
        border {
            left: 20
            right: 20
            top: 20
            bottom: 20
        }
        source: "image://theme/ContextMenu"
    }    
}
