import QtQuick 1.0
import "." 1.0

Item {
    id: appWindow

    default property alias blurChildren: blurItem.children
    property bool inPortrait: screen.inPortrait
    property Style platformStyle: PageStackWindowStyle {}
    property alias mouseArea: globalMouseArea
    property string windowTitle

    function __blur() {
        if (blurItem.effect == null) {
            if (theme.desaturation === Desaturation.Blurred) {
                blurItem.effect = Qt.createQmlObject("BlurEffect {}", blurItem);
            }
            else {
                blurItem.effect= Qt.createQmlObject("DesaturateEffect {}", blurItem);
            }
        }
        else {
            blurItem.keepBlur = true;
        }
    }

    function __deBlur() {
        if (!blurItem.keepBlur) {
            blurItem.effect = null;
        }

        blurItem.keepBlur = false;
    }

    objectName: "__appWindow"
    width: screen.width
    height: screen.height
    onWindowTitleChanged: if (windowTitle != "") platformWindow.setWindowTitle(windowTitle);

    Loader {
        id: backgroundLoader

        anchors.fill: parent
        sourceComponent: (platformStyle.background) || ((platformStyle.portraitBackground) && (screen.inPortrait)) || ((platformStyle.landscapeBackground) && (screen.inLandscape)) ? backgroundImage
                                                                                                                                                                                    : background
    }

    Component {
        id: background

        Rectangle {
            anchors.fill: parent
            color: platformStyle.backgroundColor
        }
    }

    Component {
        id: backgroundImage

        Image {
            anchors.fill: parent
            fillMode: platformStyle.backgroundFillMode
            source: screen.inPortrait ? platformStyle.portraitBackground : platformStyle.landscapeBackground
        }
    }

    Item {
        id: blurItem

        property bool keepBlur: false // Prevent de-blurring when another popup is appearing

        anchors.fill: parent
    }

    MouseArea {
        id: globalMouseArea

        /* Used for positioning of context menu objects */

        z: Number.MAX_VALUE
        objectName: "__globalMouseArea"
        anchors.fill: parent
        onPressed: mouse.accepted = false
    }
}
