#include "mainview.h"
#include <QDebug>

MainView::MainView(QWidget *parent) :
    QWidget(parent)
{
    setGeometry(0, 0, 480, 800);
    setContentsMargins(0,0,0,0);

    QString _bgImg = QString("background-image: url(%1").arg(QApplication::applicationDirPath());
    thumbnailEnabled = false;

    //setStyleSheet("background-image: url(./images/wallpaper.png)"); low performance

    readSettings();

    acceptButton = new QWidget(this);
    acceptButton->setAutoFillBackground(true);
    acceptButton->setGeometry(0, 550, 130, 130);
    acceptButton->setStyleSheet(QString(_bgImg + "/images/accept.png)"));

    rejectButton = new QWidget(this);
    rejectButton->setAutoFillBackground(true);
    rejectButton->setGeometry(350, 550, 130, 130);
    rejectButton->setStyleSheet(QString(_bgImg + "/images/reject.png)"));

    acceptDrag = false;
    rejectDrag = false;
    _acceptMousePress = false;


    numberLabel = new QLabel(this);
    numberLabel->setText("123435566");
    numberLabel->setStyleSheet("color:white;"
                         "font:28pt;"
                         "qproperty-alignment: AlignCenter;");
    numberLabel->setGeometry(0, 220, 480, 50);

    nameLabel = new QLabel(this);
    nameLabel->setText("Unknown number");
    nameLabel->setStyleSheet("color:white;"
                             "font:36pt;"
                             "qproperty-alignment: AlignCenter;");
    nameLabel->setGeometry(0, 150, 480, 50);


    greenArrow = new QWidget(this);
    greenArrow->setGeometry(acceptButton->width() + 10, acceptButton->pos().y() + acceptButton->height()/2 -4, 55, 14);
    greenArrow->setStyleSheet(QString(_bgImg + "/images/greenarrow.png)"));
    greenArrow->setAutoFillBackground(true);


    redArrow = new QWidget(this);
    redArrow->setGeometry(width() - rejectButton->width() - 10 - 55, acceptButton->pos().y() + acceptButton->height()/2 -4, 55, 14);
    redArrow->setStyleSheet(QString(_bgImg + "/images/redarrow.png)"));
    redArrow->setAutoFillBackground(true);

    statusIndicator = new QWidget(this);
    statusIndicator->setStyleSheet("background-color: red");
    statusIndicator->setGeometry(0, 0, 480, 10);
    statusIndicator->hide();
}

void MainView::readSettings()
{
    QSettings *settings = new QSettings(QSettings::IniFormat,
                                        QSettings::UserScope,
                                        "qslideanswer",
                                        "qslideanswer",
                                        this);

    if(!settings->contains("enable_wallpaper"))
        settings->setValue("enable_wallpaper", true);
    if(!settings->contains("background-color"))
        settings->setValue("background-color", "default");
    if(!settings->contains("enable_thumbnail"))
        settings->setValue("enable_thumbnail", false);

    if(settings->value("enable_wallpaper", true).toBool()) {
        QWidget *background = new QWidget(this);
        background->setGeometry(0, 0, 480, 800);
        background->setStyleSheet(QString("background-image: url(%1/images/wallpaper.png)").arg(
                                      QApplication::applicationDirPath()));
    } else {
        QString backgroundColor = settings->value("background-color", "default").toString();
        if(backgroundColor != "default") {
            setStyleSheet(QString("background-color: %1").arg(backgroundColor));
        }
    }
    if(settings->value("enable_thumbnail", false).toBool()) {
        thumbnailEnabled = true;
        thumbnail = new QLabel(this);
        thumbnail->setAutoFillBackground(true);
        thumbnail->move((this->width()-thumbnail->width())/2, 300);
        thumbnail->hide();
    }

    settings->sync();
    delete settings;
}

void MainView::mousePressEvent(QMouseEvent *event)
{
    if(!_acceptMousePress)
        return;

    offset = event->pos();
    if(offset.y() > 500 && offset.y() < 750 && offset.x() < acceptButton->width())
    {
        acceptDrag = true;
        greenArrow->hide();
        redArrow->hide();
        rejectButton->hide();
    }
    else if(offset.y() > 500 && offset.y() < 750 && offset.x() > width() - rejectButton->width())
    {
        rejectDrag = true;
        redArrow->hide();
        greenArrow->hide();
        acceptButton->hide();
    }
}

void MainView::mouseMoveEvent(QMouseEvent *event)
{
    QPoint pos = event->pos();
    xpos = pos.x() - offset.x();

    if(acceptDrag)
    {
        if(xpos >= 0 && xpos <= (240 - rejectButton->width()/2))
            acceptButton->move(xpos, acceptButton->y());
    }
    else if(rejectDrag)
    {
        if(-xpos <= (240 - rejectButton->width()/2) && xpos <= 0)
            rejectButton->move(xpos + (480 - rejectButton->width()), rejectButton->y());
    }
}

void MainView::mouseReleaseEvent(QMouseEvent *)
{
    if(xpos >= (240 - rejectButton->width()/2) && acceptDrag) {
        statusIndicator->setStyleSheet("background-color: green");
        statusIndicator->show();
        emit acceptCall();
    }
    else if(-xpos >= (240 - rejectButton->width()/2) && rejectDrag) {
        statusIndicator->setStyleSheet("background-color: red");
        statusIndicator->show();
        emit rejectCall();
    }

    acceptButton->move(0, acceptButton->y());
    rejectButton->move(350, rejectButton->y());

    greenArrow->show();
    redArrow->show();
    acceptButton->show();
    rejectButton->show();
    acceptDrag = false;
    rejectDrag = false;
}


void MainView::setNumber(const QString &number)
{
    numberLabel->setText(number);
}

void MainView::setName(const QString &name)
{
    nameLabel->setText(name);
    nameLabel->show();
}

void MainView::acceptMousePress()
{
    _acceptMousePress = true;
    showControls();
}

void MainView::rejectMousePress()
{
    _acceptMousePress = false;
}

void MainView::showControls()
{
    if(!(acceptDrag || rejectDrag)) {// don't show controls if slide is already active
        acceptButton->show();
        rejectButton->show();
        greenArrow->show();
        redArrow->show();
    }
}

void MainView::hideControls()
{
    acceptButton->hide();
    rejectButton->hide();
    greenArrow->hide();
    redArrow->hide();
    statusIndicator->hide();
    nameLabel->hide();
}

void MainView::setThumbnail(const QImage &image)
{
    if(image.isNull()) {
        thumbnail->clear();
        thumbnail->hide();
        return;
    }
    thumbnail->setPixmap(QPixmap::fromImage(image));
    thumbnail->setFixedSize(image.width(), image.height());
    thumbnail->move((this->width()-thumbnail->width())/2, 300);
    thumbnail->show();
}
