#ifndef MAINVIEW_H
#define MAINVIEW_H

#include <QWidget>
#include <QtGui>
#include <QSettings>

class MainView : public QWidget
{
    Q_OBJECT
public:
    explicit MainView(QWidget *parent = 0);

    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *);
    
private:
    QPoint offset;
    int xpos;
    bool acceptDrag;
    bool rejectDrag;
    QWidget *acceptButton;
    QWidget *rejectButton;
    QLabel *numberLabel;
    QLabel *nameLabel;
    QWidget *greenArrow;
    QWidget *redArrow;

signals:
    void acceptCall();
    void rejectCall();

public slots:
    void setNumber(const QString &number);
    void setName(const QString &name);
    
};

#endif // MAINVIEW_H
