﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
from QonsoExtractor import QonsoExtractor
from PyQt4 import QtWebKit, QtCore
from PyQt4.QtNetwork import QNetworkRequest
from DebugLog import DebugLog

class QonsoExtractorSFR(QonsoExtractor):
   def __init__(self):
      DebugLog("QonsoExtractorSFR::init")
      QonsoExtractor.__init__(self)

      # URL de la page d'info conso
      self.urlconso = "https://monprofil.sfr.fr/monprofilWEBV5/Accueil?acces=enc&sfrintid=HP_ajax_compte_txt_conso"

      # URL présentant le formulaire pour la connection au compte
      self.urlbeforeAuth = "http://www.sfr.fr/cas/login?domain=mon-compte"

      # URL où on envoie la requête POST pour l'authentification, en général, elle est dans le form
      self.urlAuth = "https://www.sfr.fr/cas/login?domain=mon-compte&service=https%3A%2F%2Fwww.sfr.fr%2Fj_spring_cas_security_check"

      self.hostname = "www.sfr.fr"

   def Authenticate(self):
      DebugLog("QonsoExtractorSFR::Authenticate")
      self.SetStatus('INFO', 'Authentification...')
      self.SetProgressRange(33,66)

      params = QtCore.QUrl()
      # Mettre ici les paramètres du formulaire (login, password, champs cachés)
      params.addQueryItem("username", self.login)
      params.addQueryItem("password", self.password)
      params.addQueryItem("loginTicket", self.ticket)
      params.addQueryItem("identifier", '')

      # cookies = self.manager.cookieJar().cookiesForUrl(QtCore.QUrl("http://"+self.hostname))
      # DebugLog("cookies %d"%len(cookies))
      # for cookie in cookies:
         # DebugLog(cookie)
         # if cookie.name()=="JSESSIONID":
             # DebugLog(cookie)

      self.PostRequest(params)

   def DoReadResponse(self, reply):
      DebugLog("QonsoExtractorSFR::DoReadResponse")

      request = QNetworkRequest()
      page = QtWebKit.QWebPage()
      frame = page.currentFrame()

      # Phase d'initialisation, on va extraire 'idCorrelation', et on lance l'authentification avec
      DebugLog("authentication=="+self.authentication)

      if self.authentication=='Init':
         html = reply.readAll()
         frame.setHtml(str(html))
         self.ticket = frame.findFirstElement('input[name=loginTicket]').attribute('value')

         self.authentication = 'InProgress'
         self.Authenticate()

      # Authentification en cours, on récupère la page de redirection, et on fait une redirection
      elif self.authentication == 'InProgress':
         html = str( reply.readAll() )

         if not self.CheckForErrors(html):
            # pas d'erreur, c'est Lesieur, on peut charger la page des consommations
            request.setUrl( QtCore.QUrl(self.urlconso) )
            self.authentication = 'Done'
            self.manager.get(request)

   def CheckForErrors(self, html):
      r = re.compile('<p class="error">\s*<span>(.+?)<.*?</p>', re.DOTALL)
      res = r.search(html)

      if res:
         DebugLog("Erreur trouvée : "+str(res.groups()) )

         error = res.group(1).strip()
         if error:
            self.SetStatus('ERROR', error)
            return True
         else:
            DebugLog("Pas d'erreur en fait...")
            return False
      return False

   # Extraction des données, dépend de chaque opérateur
   def DoExtractDatas(self, html):
      DebugLog("QonsoExtractorSFR::DoExtractDatas")

      if self.CheckForErrors(html):
         return
      # Voix
      DebugLog("\n_____________________________________\nVoix\n")
      DebugLog("-------------------------------------\n")
      r = re.compile('vous reste %s (?:de communication)?.* votre [Ff](?:orfait|ormule) (.+?)\s*<b>%s' % (self.hmReS, self.hmReS), re.DOTALL)
      res = r.search(html)
      if res:
         self.model.SetConsoVoixMax( res.group(3) )
         self.model.SetConsoVoix( res.group(1), invert=True )
         self.model.SetForfait( res.group(2) )
         DebugLog("voix2 = "+res.group(1))
         DebugLog("voixMax2 = "+res.group(3))
         DebugLog("forfait2 = "+res.group(2))
      else:
         r = re.compile('votre [Ff]orfait.*?"(.*?)"', re.DOTALL)
         r2 = re.compile('[Vv]ous avez un [Ff]orfait .+?%s et vous avez consomm.*?%s de communication'%(self.hmReS,self.hmReS), re.DOTALL)
         res = r.search(html)
         res2 = r2.search(html)
         if res:
            self.model.SetForfait( res.group(1) )
            self.model.SetConsoVoixMax( res2.group(1) )
            self.model.SetConsoVoix( res2.group(2) )
            DebugLog("forfait = "+res.group(1))
            DebugLog("voix1 = "+res.group(1))
            DebugLog("voixMax1 = "+res2.group(2))

      # Voix Supp
      DebugLog("\n____________________________________\nVoix Supp\n")
      DebugLog("-------------------------------------\n")
      r = re.compile("vous reste\s+<b>((?:\d{1,2}\s*[Hh])?\s*(?:\d{1,3}\s*(?:mi?n)?))</b>\s+de communication dans le cadre de votre option (\d+\s*h)eures", re.DOTALL)
      res = r.search(html)
      if res:
         voixSuppMax = res.group(2)
         DebugLog("voixSupp = "+res.group(1))
         DebugLog("voixSuppMax = "+voixSuppMax)
         self.model.SetConsoVoixSuppMax( voixSuppMax+"00" )
         self.model.SetConsoVoixSupp( res.group(1), invert=True )
      else:
         r = re.compile("vous reste\s+<b>((?:\d{1,2}\s*[Hh])?\s*(?:\d{1,3}\s*(?:mi?n)?))</b>\s+sur les\s+<b>((?:\d{1,2}\s*[Hh])?\s*(?:\d{1,3}\s*(?:mi?n)?))</b>.+?offertes", re.DOTALL)
         res = r.search(html)
         if res:
            voixSuppMax = res.group(2)
            DebugLog("voixSupp = "+res.group(1))
            DebugLog("voixSuppMax = "+voixSuppMax)
            self.model.SetConsoVoixSuppMax( voixSuppMax+"00" )
            self.model.SetConsoVoixSupp( res.group(1), invert=True )


      # Date de dernière communication
      DebugLog("\n_____________________________________\nDerniere communication\n")
      DebugLog("-------------------------------------\n")
      r = re.compile("prise\s*en\s*compte.*?Le\s+(\d{1,2}.*?\d{2,4}).*?(\d{1,2}).*?(\d{1,2})\s*minutes", re.DOTALL)
      res = r.search(html)
      if res:
         DebugLog(res.groups())
         date = res.group(1)
         time = "%sh%.2d" % ( res.group(2), int(res.group(3)) )
         self.model.lastTime = "Ma consommation au "+date + " &agrave; "+ time
         DebugLog("last="+self.model.lastTime)

      # Date de prochaine facture
      DebugLog("\n____________________________________\nProchaine facture\n")
      DebugLog("------------------------------------\n")
      res = re.search("avant le.+?(\d{1,2}\s*.+?\d{2,4})", html)
      if res:
         self.model.facture = "Prochaine facture : "+res.group(1)
         self.model.facture = self.model.facture.replace("\n", " ").replace("\r", "")
         DebugLog("facture="+self.model.facture)

      # Report des minutes
      DebugLog("\n_____________________________________\nReport des minutes\n")
      DebugLog("-------------------------------------\n")
      r = re.compile("Report Forfait %s de communication"%self.hmReS, re.DOTALL)
      res = r.search(html)
      if res:
         DebugLog("report = "+res.group(1))
         self.model.SetReport( res.group(1) )

      # Hors forfait
      DebugLog("\n_____________________________________\nHors forfait\n")
      DebugLog("-------------------------------------\n")
      r = re.compile("hors forfait.*?(\d+[.,]?\d*)\s.\sTTC", re.DOTALL)
      res = r.search(html)
      if res:
         self.model.SetConsoHorsForfait( res.group(1) )
         DebugLog("hforfait = "+res.group(1))

      # SMS
      DebugLog("\n_____________________________________\nSMS\n")
      DebugLog("-------------------------------------\n")
      self.model.sms = "0"
