﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os, sys, time
from PyQt4 import QtGui, QtCore, Qt
import QonsoFactory
from QonsoModel import QonsoModel
from DlgConfig import DlgConfig
from WProgress import WProgress
from DebugLog import DebugLog

class QonsoView(QtGui.QMainWindow):
   def __init__(self, argv, parent=None):
      QtGui.QMainWindow.__init__(self, parent)
      
      DebugLog("QonsoView::Init")
      self.offline = os.environ.has_key('OFFLINE')
      self.setMaximumSize(QtCore.QSize(800, 480))
      self.setMinimumSize(QtCore.QSize(480, 480))
      self.setWindowTitle('Qonso')

      self.vbox = None
      self.boxes = dict(
                  voix=None,
                  voixSupp = None,
                  sms = None,
                  smsSupp = None,
                  data = None,
                  hforfait = None,
                  facture = None)

      try:
         self.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)
      except AttributeError:
         # not on Maemo5
         pass

      self.labels = dict()
      self.config = DlgConfig()
      self.model = QonsoModel()
      self.extractor = None
      self.credentialsOk = False
      
      if not self.config.GetLogin() or not self.config.GetPassword() or not self.config.GetOperator():
         self.config.AskForCredentials()
      
      self.layoutsOK = False
      self.centralWidget = QtGui.QWidget()

      self.vbox = QtGui.QVBoxLayout()
      self.centralWidget.setLayout(self.vbox)
      self.setCentralWidget( self.centralWidget )
      self.firstDisplay = True
      
      self.credentialsOk = True
      self.CreateAppLayouts()

   def DataInit(self):
      DebugLog("QonsoView::DataInit")
      if self.offline:
         self.CreateExtractor(sys.argv[1])
         f = open( sys.argv[2], "r")
         self.extractor.SetOffline(True)
         self.extractor.ExtractDatas( f.read() )
         f.close()
         self.CreateConsoLayouts()
         self.extractor.authentication = 'Done'
      else:
         self.CreateExtractor( self.config.GetOperator() )
         self.extractor.SetOffline(False)
         self.extractor.InitAuthenticate()

   def CreateExtractor(self, op):
      DebugLog("QonsoView::CreateExtractor")
      self.extractor = QonsoFactory.CreateExtractor(op)
      self.extractor.SetView(self)
      self.extractor.SetLogin(self.config.GetLogin())
      self.extractor.SetPassword(self.config.GetPassword())
      self.extractor.SetModel(self.model)
      
   def Settings(self):
      self.config.AskForCredentials()
      if self.config.updated:
         for box in self.boxes:
            if self.boxes[box]:
            
               if box != 'lasttime':
                  l, w = self.labels[box]
                  if l:
                     print "removing "+box
                     self.boxes[box].removeWidget(l)
                  if w:
                     self.boxes[box].removeWidget(w)
                  self.labels.pop(box)
            
                  self.vbox.removeItem(self.boxes[box])
                  self.boxes[box] = None

         self.update()
         self.credentialsOk = True
         self.layoutsOK = False
         self.extractor = None
      
   def CreateAppLayouts(self):      
      DebugLog("QonsoView::CreateAppLayouts")
      exit = QtGui.QAction(QtGui.QIcon('icons/exit.png'), u'Paramètres', self)
      exit.setShortcut('Ctrl+O')
      exit.setStatusTip('Options')
      self.connect(exit, QtCore.SIGNAL('triggered()'),self.Settings)
      
      menubar = self.menuBar()
      file = menubar.addMenu('&Options')
      file.addAction(exit)

      self.statusBox = self.CreateLayout('status', None, True)
      # self.labels['status'][1].setRange( 0, 100 )
      self.labels['status'][1].setShowRules(False)
      # self.labels['status'][1].setYTop(0)
      
      self.vbox.addLayout(self.statusBox)
      self.vbox.setSpacing(0)
      self.vbox.setMargin(0)
   
   def CreateConsoLayouts(self):
      DebugLog("QonsoView::CreateConsoLayouts")
      
      iconPath = '/opt/qonso/icons'
      if not os.path.exists(iconPath):
         iconPath = 'icons'
      
      self.boxes['compte'] = self.CreateLayout('lasttime', None)
      self.vbox.addLayout(self.boxes['compte'])
      
      self.boxes['voix'] = self.CreateLayout('voix', os.path.join(iconPath, 'voix.png'), True)
      self.vbox.addLayout(self.boxes['voix'])
      
      if self.model.GetConsoVoixSupp('str'):
         self.boxes['voixSupp'] = self.CreateLayout('voixSupp', os.path.join(iconPath, 'voixsupp.png'), True)
         self.vbox.addLayout(self.boxes['voixSupp'])
      
      if self.model.GetConsoSMSMax() != '0':
         self.boxes['sms'] = self.CreateLayout('sms', os.path.join(iconPath, 'sms.png') )
         self.vbox.addLayout(self.boxes['sms'])
      
      if self.model.GetConsoSMSSupp():
         self.boxes['smsSupp'] = self.CreateLayout('smsSupp', os.path.join(iconPath, 'smssupp.png') )
         self.vbox.addLayout(self.boxes['smsSupp'])
      
      if self.model.GetConsoDataMax()>0:
         self.boxes['data'] = self.CreateLayout('data', os.path.join(iconPath, 'data.png'), True)
         self.vbox.addLayout(self.boxes['data'])

      self.boxes['hforfait'] = self.CreateLayout('hforfait', os.path.join(iconPath, 'hforfait.png'), False)
      self.vbox.addLayout(self.boxes['hforfait'])

      self.boxes['facture'] = self.CreateLayout('facture', None)
      self.vbox.addLayout(self.boxes['facture'])

      self.layoutsOK = True
      self.UpdateConsoText()

   def CreateLayout(self, name, icon, progress=False):
      DebugLog("QonsoView::CreateLayout(%s, %s, %d)" % (name, str(icon), progress) )
      
      box = QtGui.QHBoxLayout()
      box.setSpacing(0)
      box.setMargin(0)
      
      if icon:
         pixicon = QtGui.QPixmap(icon).scaled(64,64)
         label = QtGui.QLabel()
         label.setMinimumSize(QtCore.QSize(74, 74))
         label.setMaximumSize(QtCore.QSize(96, 250))
         label.setStyleSheet("background: #fff; margin: 0; padding: 5px; border-bottom: 1px solid #269CCA;")
         label.setPixmap(pixicon)
         box.addWidget(label)

      data = QtGui.QLabel()

      sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Preferred)
      sizePolicy.setHorizontalStretch(1)
      sizePolicy.setVerticalStretch(1)
      sizePolicy.setHeightForWidth(data.sizePolicy().hasHeightForWidth())
      data.setSizePolicy(sizePolicy)
      data.setMaximumSize(QtCore.QSize(800, 800))
      data.setStyleSheet("background: #fff;")
      data.setAlignment(QtCore.Qt.AlignCenter)
      
      vbox = QtGui.QVBoxLayout()
      vbox.addWidget(data)
      wid = None
      
      if progress:
         # wid = QtGui.QProgressBar()
         # wid.setTextVisible(False)
         wid = WProgress(self)
         wid.setStyleSheet("background: #fff; margin: 0; padding: 10px; border-bottom: 1px solid #269CCA")
         vbox.addWidget(wid)
         wid.setMaximumSize(QtCore.QSize(800, 70))
      else:
         data.setStyleSheet("background: #fff; margin: 0; padding: 5px; border-bottom: 1px solid #269CCA")

      box.addLayout(vbox)
         
      self.labels[name] = data, wid
      return box

   def UpdateConsoText(self):
      if not self.extractor:
         return 
      
      status, context = self.extractor.GetStatus()

      if status=='ERROR':
         self.SetText(self.labels['status'][0], "#F00", 16, context)
         self.labels['status'][1].setValue( self.extractor.GetProgress() )

      elif status=='DONE':
         self.labels['status'][0].hide()
         self.labels['status'][1].hide()
         
      else:
         self.SetText(self.labels['status'][0], "#269CCA", 16, context)
         self.labels['status'][1].setValue( self.extractor.GetProgress() )
         time.sleep(0.005)
         self.update()
         
      if self.model.GetLastTime():
         self.SetText(self.labels['lasttime'][0], "#269CCA", 16, self.model.GetLastTime()+
                      "<br/>"+self.model.GetReport('str'))

      if self.labels.has_key('voix'):
         self.SetText(self.labels['voix'][0], "#EB5F18", 20, self.model.GetConsoVoix('str')+" / "+self.model.GetConsoVoixMax('str') )
         self.labels['voix'][1].setRange(0, self.model.GetConsoVoixMax('int'))
         self.labels['voix'][1].setValue( self.model.GetConsoVoix('int') )

      if self.labels.has_key('voixSupp'):
         self.SetText(self.labels['voixSupp'][0], "#EB5F18", 20, self.model.GetConsoVoixSupp('str')+" / "+self.model.GetConsoVoixSuppMax('str') )
         self.labels['voixSupp'][1].setRange(0, self.model.GetConsoVoixSuppMax('int'))
         self.labels['voixSupp'][1].setValue( self.model.GetConsoVoixSupp('int') )

      if self.labels.has_key('sms'): # and self.model.GetConsoSMSMax() != '0':
         self.SetText(self.labels['sms'][0], "#EB5F18", 20, self.model.GetConsoSMS() +"/" + self.model.GetConsoSMSMax())

      if self.labels.has_key('smsSupp'):
         self.SetText(self.labels['smsSupp'][0], "#EB5F18", 20, self.model.GetConsoSMSSupp() +"/" + self.model.GetConsoSMSSuppMax())

      if self.labels.has_key('data'):
         dataMax = self.model.GetConsoDataMax()
         data = self.model.GetConsoData()
         self.SetText(self.labels['data'][0], "#EB5F18", 20, str(data)+" / "+str(dataMax)+"Mo")
         self.labels['data'][1].setRange(0, dataMax)
         self.labels['data'][1].setValue( data )
      
      if self.labels.has_key('hforfait'):
         self.SetText(self.labels['hforfait'][0], "#EB5F18", 20, self.model.GetConsoHorsForfait() )
         
      if self.labels.has_key('facture'):
         self.SetText(self.labels['facture'][0], "#269CCA", 16, self.model.GetDateProchaineFacture())

   def SetText(self, label, color, size, text):
      label.setText('<span style="color: %s; font-weight: bold; font-size: %dpt">%s</span>' % (color, size, text))
   
   def paintEvent(self, event):
      if self.firstDisplay:
         if self.credentialsOk and (not self.extractor or not self.extractor.authentication):
            self.DataInit()
         elif not self.layoutsOK:
            if self.extractor and self.extractor.datasExtracted:
               self.CreateConsoLayouts()
               self.extractor.datasExtracted = False 
      self.firstDisplay = True
      self.UpdateConsoText()
      
   def closeEvent(self, event):
      self.config.WriteConfig()
      event.accept()
