﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
from DebugLog import DebugLog

class QonsoModel:
   def __init__(self):
      self.lastTime = ""
      self.voix = dict(int=0, str="0 min")
      self.voixSupp = None
      self.voixSuppMax = None
      self.voixMax = dict(int=0, str="0 min")
      self.data = ""
      self.dataMax = 0
      self.forfait = ""
      self.hforfait = "0 &euro;"
      self.facture = "Prochaine facture : "
      self.sms = '0'
      self.smsMax = '0'
      self.smsSupp = None
      self.smsSuppMax = '0'
      self.report = dict(int=0, str="Pas de minutes report&eacute;es ce mois ci")
      self.regHM = re.compile("(\d+\s*[Hh])?\s*(\d+)", re.DOTALL)
#      self.regHM = "(\d+)*?\s*[Hh]?\s*(\d+)"
      
   def NotFilled(self):
      if not self.GetLastTime():
         DebugLog("QonsoModel::NotFilled True")
         return True
      else:
         DebugLog("QonsoModel::NotFilled True")
         return False
      
   def GetLastTime(self):
      return self.lastTime

   def SetForfait(self, forfait):
      self.forfait = forfait

   def GetForfait(self):
      return self.forfait

   def TimeStrFromInt(self, timenum):
      h = int(timenum/60)
      m = timenum-h*60

      timestr = ""
      if h>=1:
         timestr = str(h)+"h"
      timestr = "%s%.2d min"%(timestr, m)
      return timestr
   
      
   def ExtractTime(self, s):
      s = s.replace('\n', '').replace('\r', '')
      res = self.regHM.search(s)
      timenum = 0
      timestr = "0 min"

      if res:
         h = 0
         if res.group(1):
            h = int(res.group(1)[:-1])
         m = int(res.group(2))
         timenum = h*60+m
         timestr = self.TimeStrFromInt(timenum)
      
      return timenum, timestr
      
   ## 
   # Remplit les données pour la consommation voix
   # @param s  string contenant les données au format [hh]h[mm] (ex : 2h 30)
   def SetConsoVoix(self, s, invert=False):
      self.voix['int'], self.voix['str'] = self.ExtractTime(s)
      if invert:
         self.voix['int'] = self.voixMax['int']-self.voix['int']
         self.voix['str'] = self.TimeStrFromInt(self.voix['int'])
   
   ##
   # Renvoit la consommation voix, en fonction du type
   # @param type  string prenant comme valeur 'int' ou 'str'
   # @return  consommation voix en minutes (int), ou au format 2h30 (str)
   def GetConsoVoix(self, type):
      return self.voix[type]

   ## 
   # Remplit les données pour la consommation voix
   # @param s  string contenant les données au format [hh]h[mm] (ex : 2h 30)
   def SetConsoVoixSupp(self, s, invert=False):
      self.voixSupp = dict(int=0, str="0 min")
      self.voixSupp['int'], self.voixSupp['str'] = self.ExtractTime(s)
      if invert:
         self.voixSupp['int'] = self.voixSuppMax['int']-self.voixSupp['int']
         self.voixSupp['str'] = self.TimeStrFromInt(self.voixSupp['int'])
   
   ##
   # Renvoit la consommation voix, en fonction du type
   # @param type  string prenant comme valeur 'int' ou 'str'
   # @return  consommation voix en minutes (int), ou au format 2h30 (str)
   def GetConsoVoixSupp(self, type):
      if self.voixSupp:
         return self.voixSupp[type]
      else:
         return None

   ## 
   # Remplit les données pour la consommation voix
   # @param s  string contenant les données au format [hh]h[mm] (ex : 2h 30)
   def SetConsoVoixSuppMax(self, s):
      self.voixSuppMax = dict(int=0, str="0 min")
      self.voixSuppMax['int'], self.voixSuppMax['str'] = self.ExtractTime(s)

   ##
   # Renvoit la consommation voix, en fonction du type
   # @param type  string prenant comme valeur 'int' ou 'str'
   # @return  consommation voix en minutes (int), ou au format 2h30 (str)
   def GetConsoVoixSuppMax(self, type):
      if self.voixSupp:
         return self.voixSuppMax[type]
      else:
         return None
         
   ## 
   # Remplit la durée du forfait pour la consommation voix
   # @param s  string contenant les données au format [hh]h[mm] (ex : 2h 30)
   def SetConsoVoixMax(self, s):
      self.voixMax['int'], self.voixMax['str'] = self.ExtractTime(s)

   ##
   # Renvoit la durée du forfait pour la consommation voix, en fonction du type
   # @param type  string prenant comme valeur 'int' ou 'str'
   # @return  consommation voix en minutes (int), ou au format 2h30 (str)
   def GetConsoVoixMax(self, type):
      return self.voixMax[type]

   ## 
   # Remplit les données pour la consommation data (internet)
   # @param s  string contenant la taille des données sous forme numérique (example : 110)
   def GetConsoData(self):
      if self.data:
         return self.data.simplified().replace("Mo", "").toFloat()[0]
      else:
         return 0

   ##
   # Renvoit la taille du forfait data
   # @return  consommation data en Mo
   def GetConsoDataMax(self):
      return self.dataMax

   ##
   # Renvoit le nombre de SMS émis
   # @param sms  int  Nombre de sms
   def SetConsoSMS(self, sms):
      self.sms = sms

   ##
   # Renvoit le nombre de SMS émis
   # @return  nombre de SMS
   def GetConsoSMS(self):
      return self.sms
      
   ##
   # Renvoit le nombre de SMS émis
   # @param sms  int  Nombre de sms
   def SetConsoSMSSupp(self, sms):
      self.smsSupp = sms

   ##
   # Renvoit le nombre de SMS émis
   # @return  nombre de SMS
   def GetConsoSMSSupp(self):
      return self.smsSupp

   ##
   # Renvoit le nombre de SMS émis
   # @param sms  int  Nombre de sms
   def SetConsoSMSSuppMax(self, sms):
      self.smsSuppMax = sms

   ##
   # Renvoit le nombre de SMS émis
   # @return  nombre de SMS
   def GetConsoSMSSuppMax(self):
      return self.smsSuppMax

   ##
   # Renvoit le nombre de SMS disponibles dans le forfait
   # @param sms  int  Nombre de sms
   def SetConsoSMSMax(self, sms):
      self.smsMax = sms

   ##
   # Renvoit le nombre de SMS dispo dans le forfait
   # @return  nombre de SMS
   def GetConsoSMSMax(self):
      return self.smsMax

   ##
   # Replit le montant de la consommation hors forfait 
   # @param hforfait  int
   def SetConsoHorsForfait(self, hforfait):
      self.hforfait = str(hforfait)+" &euro;"

   ##
   # Renvoit le montant de la consommation hors forfait
   # @return  consommation hors forfait en Euros
   def GetConsoHorsForfait(self):
      return self.hforfait

   def GetDateProchaineFacture(self):
      return self.facture 
      
   ## 
   # Remplit la durée des minutes reportées
   # @param s  string contenant les données au format [hh]h[mm] (ex : 2h 30)
   def SetReport(self, s):
      self.report['int'], sreport = self.ExtractTime(s)

      if self.report['int'] == 0:
         self.report['str'] = "Pas de minutes report&eacute;es ce mois ci"
      else:
         self.report['str'] = "Report de minutes : "+sreport
      
   ##
   # Renvoit la durée des minutes reportées, en fonction du type
   # @param type  string prenant comme valeur 'int' ou 'str'
   # @return  consommation voix en minutes (int), ou au format 2h30 (str)      
   def GetReport(self, type):
      return self.report[type]
