﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
from QonsoExtractor import QonsoExtractor
from PyQt4 import QtWebKit, QtCore
from PyQt4.QtNetwork import QNetworkRequest

class QonsoExtractorOrange(QonsoExtractor):
   def __init__(self):
      QonsoExtractor.__init__(self)
      
      # URL de la page d'info conso
      self.urlconso = "https://monprofil.sfr.fr/monprofilWEBV5/Accueil?acces=enc"
      
      # URL présentant le formulaire pour la connection au compte
      self.urlbeforeAuth = "https://www.sfr.fr/cas/login?domain=mon-compte"
      
      # URL où on envoie la requête POST pour l'authentification, en général, elle est dans le form 
      self.urlAuth = "https://www.sfr.fr/cas/login?domain=mon-compte&service=https%3A%2F%2Fwww.sfr.fr%2Fj_spring_cas_security_check"
      
      self.hostname = "www.sfr.fr"
      
   def Authenticate(self):
      self.SetStatus('INFO', 'Authentification...')

      params = QtCore.QUrl()
      # Mettre ici les paramètres du formulaire (login, password, champs cachés)
      params.addQueryItem("username", self.login)
      params.addQueryItem("password", self.password)
      params.addQueryItem("internal", "W")
      #
      
      self.PostRequest(params)
      
   def DoReadResponse(self, reply):
      request = QNetworkRequest()
      page = QtWebKit.QWebPage()
      frame = page.currentFrame()

      # Phase d'initialisation, on va extraire 'idCorrelation', et on lance l'authentification avec
      if self.authentication=='Init':
         self.authentication = 'InProgress'
         self.Authenticate()
      
      # Authentification en cours, on récupère la page de redirection, et on fait une redirection
      elif self.authentication == 'InProgress':
         html = reply.readAll()
         frame.setHtml(str(html))
         # Gestion des erreurs, retrouver l'erreur sur la page et la mettre dans le status
         errors = frame.findAllElements('p[class="error"]')

         if errors:
            self.Debug("erreur")
            for error in errors:
               self.SetStatus('ERROR', error.toPlainText())
               return
         else:
            # pas d'erreur, c'est Lesieur, on peut charger la page des consommations
            request.setUrl( QtCore.QUrl(self.urlconso) ) 
            self.authentication = 'Done'
            self.manager.get(request)

   # Extraction des données, dépend de chaque opérateur
   def ExtractDatas(self, datas):
      self.Debug("ExtractDatas")
      self.SetStatus('INFO', 'R&eacute;cup&eacute;ration des donn&eacute;es...')

      strElem = str(datas)
      
      # Voix
      self.Debug("\n____________________________________________\nVoix\n")
      self.Debug("-----------------------------------------------\n")
      r = re.compile('votre forfait.*?"(.*?)".*?vous avez un forfait .+?%s et vous avez consomm.*?%s de communication'%(self.hmReS,self.hmReS), re.DOTALL|re.IGNORECASE)
      res = r.search(strElem)
      if res:
         self.model.SetForfait( res.group(1) )
         self.model.SetConsoVoixMax( res.group(2) )
         self.model.SetConsoVoix( res.group(3) )
         self.Debug("forfait = "+res.group(1))
         self.Debug("voix1 = "+res.group(1))
         self.Debug("voixMax1 = "+res.group(3))
         
      r = re.compile('il vous reste %s de communication .* votre forfait (.+?)\s*<b>%s' % (self.hmReS, self.hmReS), re.DOTALL|re.IGNORECASE)
      res = r.search(strElem)
      if res:
         self.model.SetConsoVoix( res.group(1) )
         self.model.SetConsoVoixMax( res.group(3) )
         self.model.InvertConsoVoix()
         self.model.SetForfait( res.group(2) )
         self.Debug("voix2 = "+res.group(1))
         self.Debug("voixMax2 = "+res.group(3))
         self.Debug("forfait2 = "+res.group(2))

      # Date de dernière communication
      self.Debug("\n____________________________________________\nDerniere communication\n")
      self.Debug("-----------------------------------------------\n")
      r = re.compile("prise en compte.*Le\s+(\d{1,2}.*?\d{2,4}).*?(\d{1,2}).*(\d{1,2})\s*minutes", re.DOTALL)
      res = r.search(strElem)
      if res:
         self.Debug(res.groups())
         date = res.group(1)
         time = "%sh%.2d" % ( res.group(2), int(res.group(3)) )
         self.model.lastTime = "Ma consommation au "+date + " &agrave; "+ time
         self.Debug("last="+self.model.lastTime)
         
      # Date de prochaine facture
      self.Debug("\n____________________________________________\nProchaine facture\n")
      self.Debug("-----------------------------------------------\n")
      res = re.search("avant le.+?(\d{1,2}.+?\d{2,4})", strElem)
      if res:
         self.model.facture = "Prochaine facture : "+res.group(1)
         self.Debug("facture="+self.model.facture)
         
      # Report des minutes
      self.Debug("\n____________________________________________\nReport des minutes\n")
      self.Debug("-----------------------------------------------\n")
      r = re.compile("Report Forfait %s de communication"%self.hmReS, re.DOTALL)
      res = r.search(strElem)
      if res:
         self.Debug("report = "+res.group(1))
         self.model.SetReport( res.group(1) )

      # Hors forfait
      self.Debug("\n____________________________________________\nHors forfait\n")
      self.Debug("-----------------------------------------------\n")
      r = re.compile("hors forfait.*?(\d+[.,]?\d*)\s.\sTTC", re.DOTALL)
      res = r.search(strElem)
      if res:
         self.model.SetConsoHorsForfait( res.group(1) )
         self.Debug("hforfait = "+res.group(1))

      # SMS
      self.Debug("\n____________________________________________\nSMS\n")
      self.Debug("-----------------------------------------------\n")
      self.model.sms = "0"
      self.SetStatus('INFO', u'Données récupérées...')

      self.datasExtracted = True
      if self.view:
         self.view.update()
