﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
from ConfigParser import ConfigParser
from PyQt4 import QtGui, QtCore

class DlgConfig:
   def __init__(self):
      confDir = os.path.join(os.path.expanduser('~'),".qonso")
      if not os.path.exists(confDir):
         os.makedirs(confDir)
      self.confFile = os.path.join(confDir, "qonso.conf")
      self.conf = ConfigParser()
      self.LoadConfig()

   def LoadConfig(self):
      if os.path.exists(self.confFile):
         self.conf.read( [self.confFile] )

      else:
         self.conf.add_section('user')
         
   def WriteConfig(self):
      f = open(self.confFile, "w")
      self.conf.write(f)
      f.close()

   def GetLogin(self):
      login = None
      try:
         login = self.conf.get('user', 'login', "")
      except:
         pass
      
      return login
      
   def GetPassword(self):
      password = None
      try:
         password = self.conf.get('user', 'password', "")
      except:
         pass
      
      return password
      
   def SetCredentials(self, credentials):
      if not self.conf.has_section('user'):
         self.conf.add_section('user')
      login, password = credentials
      self.conf.set('user', 'login', login)
      self.conf.set('user', 'password', password)
      
   def SetOperator(self, operator):
      if not self.conf.has_section('user'):
         self.conf.add_section('user')
      self.conf.set('user', 'operator', operator)

   def GetOperator(self):
      if not self.conf.has_section('user'):
         return None
      operator = ""
      try:
         operator = self.conf.get('user', 'operator', "")
      except:
         return None
         
      return operator

   def AskForCredentials(self):
      self.dlg = QtGui.QDialog()

      hLayout = QtGui.QHBoxLayout()
      labelid = QtGui.QLabel()
      labelid.setText("Num. de mobile")
      self.login = QtGui.QLineEdit()
      hLayout.addWidget(labelid)
      hLayout.addWidget(self.login)
      
      hLayout2 = QtGui.QHBoxLayout()
      labelpwd = QtGui.QLabel()
      labelpwd.setText("Code secret")
      self.password = QtGui.QLineEdit()
      self.password.setEchoMode(QtGui.QLineEdit.Password)
      hLayout2.addWidget(labelpwd)
      hLayout2.addWidget(self.password)

      hLayoutCombo = QtGui.QHBoxLayout()
      operateur = QtGui.QLabel()
      operateur.setText(u"Opérateur")
      self.comboop = QtGui.QComboBox()
      self.comboop.addItem("Bouygues Telecom")
      self.comboop.addItem("SFR")
      #self.comboop.addItem("Orange")
      hLayoutCombo.addWidget(operateur)
      hLayoutCombo.addWidget(self.comboop)
      
      self.login.setText(self.GetLogin())
      self.password.setText(self.GetPassword())

      hLayout3 = QtGui.QHBoxLayout()
      buttonOK = QtGui.QDialogButtonBox()
      buttonOK.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)

      hLayout3.addWidget(buttonOK)

      vbox = QtGui.QVBoxLayout()
      vbox.addLayout(hLayout)
      vbox.addLayout(hLayout2)
      vbox.addLayout(hLayoutCombo)
      vbox.addLayout(hLayout3)
      
      self.dlg.setLayout(vbox)
      self.dlg.setModal(True)
      self.dlg.connect(buttonOK, QtCore.SIGNAL("accepted()"), self.OnOK)
      self.dlg.connect(buttonOK, QtCore.SIGNAL("rejected()"), self.OnCancel)      

      self.dlg.exec_()


   def OnOK(self):
      self.SetCredentials( (self.login.text(), self.password.text()) )
      self.SetOperator( self.comboop.currentText() )
      self.dlg.accept()

   def OnCancel(self):
      self.dlg.reject()
