#include "wlash.h"
#include "ui_wlash.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Wlash::Wlash(QWidget *parent):
    QDialog(parent),
       ui(new Ui::Wlash)


{
    ui->setupUi(this);

    this->setWindowTitle(tr("Lashings"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    ui->pushButtonLdiag->setText(tr("Diagonal Lashing"));
    ui->pushButtonLround->setText(tr("Round Lashing"));
    ui->pushButtonLshear->setText(tr("Shear Lashing"));
    ui->pushButtonLsquare->setText(tr("Square Lashing"));
    ui->pushButtonLtripod->setText(tr("Tripod Lashing"));

    // For Connecting Keyboard Buttons
      connectSignals();
}

Wlash::~Wlash()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Wlash::connectSignals()
{

// Keyboard Key Signals

   connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonLdiag_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonLround_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonLshear_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_R), this), SIGNAL(activated()), this, SLOT(on_pushButtonLsquare_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_T), this), SIGNAL(activated()), this, SLOT(on_pushButtonLtripod_pressed()));
}

// End of Keyboard Signals

//Buttons

void Wlash::on_pushButtonLdiag_pressed()
{
    Ldiag *ldiag = new Ldiag(this);
    ldiag->show();
}

void Wlash::on_pushButtonLround_pressed()
{
    Lround *lround = new Lround(this);
    lround->show();
}

void Wlash::on_pushButtonLshear_pressed()
{
    Lshear *lshear = new Lshear(this);
    lshear->show();
}

void Wlash::on_pushButtonLsquare_pressed()
{
    Lsquare *lsquare = new Lsquare(this);
    lsquare->show();
}

void Wlash::on_pushButtonLtripod_pressed()
{
    Ltripod *ltripod = new Ltripod(this);
    ltripod->show();
}

