#include "whitch.h"
#include "ui_whitch.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Whitch::Whitch(QWidget *parent):
    QDialog(parent),
       ui(new Ui::Whitch)


{
    ui->setupUi(this);

    this->setWindowTitle(tr("Hitches"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    ui->pushButtonKanchor->setText(tr("Anchor Hitch"));
    ui->pushButtonKbuntline->setText(tr("Buntline Hitch"));
    ui->pushButtonKclove->setText(tr("Clove Hitch"));
    ui->pushButtonKtimber->setText(tr("Timber Hitch"));
    ui->pushButtonKtruckers->setText(tr("Trucker's Hitch"));
    ui->pushButtonKtumble->setText(tr("Tumble Hitch"));

    // For Connecting Keyboard Buttons
      connectSignals();
}

Whitch::~Whitch()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Whitch::connectSignals()
{

// Keyboard Key Signals

   connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonKanchor_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonKbuntline_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonKclove_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_R), this), SIGNAL(activated()), this, SLOT(on_pushButtonKtimber_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_T), this), SIGNAL(activated()), this, SLOT(on_pushButtonKtruckers_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_Y), this), SIGNAL(activated()), this, SLOT(on_pushButtonKtumble_pressed()));
}

// End of Keyboard Signals

//Buttons

void Whitch::on_pushButtonKanchor_pressed()
{
    Kanchor *kanchor = new Kanchor(this);
    kanchor->show();
}

void Whitch::on_pushButtonKbuntline_pressed()
{
    Kbuntline *kbuntline = new Kbuntline(this);
    kbuntline->show();
}

void Whitch::on_pushButtonKclove_pressed()
{
    Kclove *kclove = new Kclove(this);
    kclove->show();
}

void Whitch::on_pushButtonKtimber_pressed()
{
    Ktimber *ktimber = new Ktimber(this);
    ktimber->show();
}

void Whitch::on_pushButtonKtruckers_pressed()
{
    Ktruckers *ktruckers = new Ktruckers(this);
    ktruckers->show();
}

void Whitch::on_pushButtonKtumble_pressed()
{
    Ktumble *ktumble = new Ktumble(this);
    ktumble->show();
}
