#include "kclove.h"
#include "ui_kclove.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Kclove::Kclove(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Kclove)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Clove Hitch"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/kclove.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);


    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/kclove.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();

    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Clove Hitch</u></b> <br> \
        <b>Open Object Method</b> <br> \
        Pass the working part over the standing part to make a loop in the rope, place it over the object. <br> \
        Take the working end an make an identical second loop and place that over the object. <br> \
        Pull the working and standing ends to tighten around the object. <br> \
        <b>Closed Object Method</b> <br> \
        Make a turn around the object. <br> \
        Continue to make a second turn around the object crossing over the standing end. <br> \
        Finally pass the end under itself. <br> \
        Pull the working and standing ends to tighten around the object. <br> \
        <b>Important</b> <br> \
        A Clove Hitch is not recommended to be used as a hitch to secure a load. <br> \
        It is listed here as it's construction is used to form other knots. <br> \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();
}

Kclove::~Kclove()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Kclove::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void Kclove::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void Kclove::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void Kclove::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
