#ifndef CONVERTER_H
#define CONVERTER_H

#include <QHash>
#include <QStringList>

class Converter
{
	typedef struct {
		QStringList order;
		QHash<QString, QString> eqnf;
		QHash<QString, QString> eqnt;
	} type_data_t;

	QHash<QString, type_data_t*> data;

	void add_si_units(QString *type, QString *unit);
	double rpn_eval(QString type, double val, QString formula);

	typedef struct {
		QString prefix;
		int power;
	} si_prefix_t;
	static si_prefix_t prefixes[20];

public:
    Converter();
	void add_file(char *file);
	QString convert(QString type, QString ou, QString nu, QString val);
	QStringList get_order(QString type);
};

#endif // CONVERTER_H
