import QtQuick 1.0

Item {
    id: root

    property alias buttons: buttonRow.children
    property string separatorPosition: "bottom"

    height: 50

    Rectangle {
        anchors.fill: parent
        gradient: Gradient {
            GradientStop { id: gradient1; position: 0.0; color: Settings.gradientColorHigh }
            GradientStop { id: gradient2; position: 0.7; color: Settings.gradientColor }
        }
        opacity: 0.7
        smooth: true
        states: State {
            name: "highlight"
            PropertyChanges { target: gradient1; color: Qt.lighter(Settings.activeColor, 1.2) }
            PropertyChanges { target: gradient2; color: Settings.activeColor }
        }

        Rectangle {
            height: 1
            anchors { left: parent.left; right: parent.right; bottom: separatorPosition == "bottom" ? parent.bottom : undefined; top: separatorPosition == "top" ? parent.top : undefined }
            color: Settings.activeColor
        }
    }

    Row {
        id: buttonRow

        anchors.fill: root
    }
}


