import QtQuick 1.0
import "components"
import "scripts/youtube.js" as YT
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property string videoId
    property alias commentCount: commentsModel.count

    function setCommentsFeed(id) {
        videoId = id;
        YT.getComments(id);
    }

    function goToUserProfile(username) {
        pageStack.push(Qt.resolvedUrl("YTUserPage.qml"));
        pageStack.currentPage.getUserProfile(username);
    }

    function showCommentDialog() {
        var commentDialog = ObjectCreator.createObject(Qt.resolvedUrl("AddCommentDialog.qml"), appWindow);
        commentDialog.site = "youtube";
        commentDialog.videoId = videoId;
        commentDialog.open();
    }

    title: qsTr("Comments")
    tools: Menu {

        menuItems: MenuItem {
            text: qsTr("Add comment")
            enabled: YouTube.userSignedIn
            onClicked: showCommentDialog()
        }
    }

    Connections {
        target: YouTube
        onCommentAdded: {
            if (id == videoId) {
                messages.displayMessage(messages._COMMENT_ADDED);
                commentsModel.reset();
            }
        }
    }

    ListView {
        id: commentsList

        anchors.fill: parent
        clip: true
        maximumFlickVelocity: Settings.maximumFlickVelocity
        highlightRangeMode: ListView.NoHighlightRange
        footer: Item {
            id: footer

            width: commentsList.width
            height: 100
            visible: commentsModel.loading

            BusyDialog {
                anchors.centerIn: footer
                visible: footer.visible
            }
        }

        model: ListModel {
            id: commentsModel

            property bool loading: false
            property int totalResults
            property int page: 0

            function reset() {
                commentsModel.clear();
                commentsModel.totalResults = 0;
                commentsModel.page = 0;
                YT.getComments(videoId);
            }
        }

        onAtYEndChanged: if ((atYEnd) && (commentsModel.count < commentsModel.totalResults) && (!commentsModel.loading)) YT.getComments(videoId);
        delegate: YTCommentsDelegate {
            id: commentDelegate

            onCommentClicked: goToUserProfile(author)
        }

        ScrollBar {}
    }

    Label {
        id: noResultsText

        anchors.centerIn: commentsList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No comments")
        visible: (!commentsModel.loading) && (commentsModel.count == 0)
    }
}
