#ifndef SETTINGS_H
#define SETTINGS_H

#include "qmlapplicationviewer.h"
#include <QSettings>
#include <QStringList>

class Settings : public QSettings
{
    Q_OBJECT
    Q_PROPERTY(QString youtubeDownloadQuality
               READ getYouTubeDownloadQuality
               WRITE setYouTubeDownloadQuality
               NOTIFY youtubeDownloadQualityChanged)
    Q_PROPERTY(QString homescreen
               READ getHomescreen
               WRITE setHomescreen
               NOTIFY homescreenChanged)
    Q_PROPERTY(QString downloadPath
               READ getDownloadPath
               WRITE setDownloadPath
               NOTIFY downloadPathChanged)
    Q_PROPERTY(QString defaultTransferStatus
               READ getDefaultTransferStatus
               WRITE setDefaultTransferStatus
               NOTIFY defaultTransferStatusChanged)
    Q_PROPERTY(QString transferPriority
               READ getTransferPriority
               WRITE setTransferPriority
               NOTIFY transferPriorityChanged)
    Q_PROPERTY(bool pauseWhenMinimized
               READ getPauseWhenMinimized
               WRITE setPauseWhenMinimized
               NOTIFY pauseWhenMinimizedChanged)
    Q_PROPERTY(bool monitorClipboard
               READ getMonitorClipboard
               WRITE setMonitorClipboard
               NOTIFY monitorClipboardChanged)
    Q_PROPERTY(bool playClipboardVideos
               READ getPlayClipboardVideos
               WRITE setPlayClipboardVideos
               NOTIFY playClipboardVideosChanged)
    Q_PROPERTY(bool downloadClipboardVideos
               READ getDownloadClipboardVideos
               WRITE setDownloadClipboardVideos
               NOTIFY downloadClipboardVideosChanged)
    Q_PROPERTY(bool safeSearch
               READ getSafeSearch
               WRITE setSafeSearch
               NOTIFY safeSearchChanged)
    Q_PROPERTY(QStringList recentSearches
               READ getRecentSearches
               WRITE setRecentSearches
               NOTIFY recentSearchesChanged)
    Q_PROPERTY(QString searchOrder
               READ getSearchOrder
               WRITE setSearchOrder
               NOTIFY searchOrderChanged)
    Q_PROPERTY(QString appTheme
               READ getTheme
               WRITE setTheme
               NOTIFY themeChanged)
    Q_PROPERTY(QString activeColor
               READ getActiveColor
               WRITE setActiveColor
               NOTIFY activeColorChanged)
    Q_PROPERTY(QString activeColorString
               READ getActiveColorString
               WRITE setActiveColorString
               NOTIFY activeColorStringChanged)
    Q_PROPERTY(QString gradientColor
               READ getGradientColor
               WRITE setGradientColor
               NOTIFY gradientColorChanged)
    Q_PROPERTY(QString gradientColorHigh
               READ getGradientColorHigh
               WRITE setGradientColorHigh
               NOTIFY gradientColorHighChanged)
    Q_PROPERTY(QString language
               READ getLanguage
               WRITE setLanguage
               NOTIFY languageChanged)
    Q_PROPERTY(QString screenOrientation
               READ getOrientation
               WRITE setOrientation
               NOTIFY orientationChanged)
    Q_PROPERTY(QString networkProxy
               READ getNetworkProxy
               WRITE setNetworkProxy
               NOTIFY networkProxyChanged)
    Q_PROPERTY(QString mediaPlayer
               READ getMediaPlayer
               WRITE setMediaPlayer
               NOTIFY mediaPlayerChanged)
    Q_PROPERTY(QString defaultSite
               READ getDefaultSite
               WRITE setDefaultSite
               NOTIFY defaultSiteChanged)

public:
    explicit Settings(QSettings *parent = 0);
    virtual ~Settings();
    QString getYouTubeDownloadQuality() const { return youtubeDownloadQuality; }
    QString getHomescreen() const { return homescreen; }
    QString getDefaultTransferStatus() const { return defaultTransferStatus; }
    QString getTransferPriority() const { return transferPriority; }
    bool getPauseWhenMinimized() { return pauseWhenMinimized; }
    bool getMonitorClipboard() { return monitorClipboard; }
    bool getPlayClipboardVideos() { return playClipboardVideos; }
    bool getDownloadClipboardVideos() { return downloadClipboardVideos; }
    QString getDownloadPath() const { return downloadPath; }
    bool getSafeSearch() { return safeSearch; }
    QStringList getRecentSearches() const { return recentSearches; }
    QString getSearchOrder() const { return searchOrder; }
    QString getTheme() const { return theme; }
    QString getActiveColor() const { return activeColor; }
    QString getActiveColorString() const { return activeColorString; }
    QString getGradientColor() const { return gradientColor; }
    QString getGradientColorHigh() const { return gradientColorHigh; }
    QString getLanguage() const { return language; }
    QString getOrientation() const { return screenOrientation; }
    QString getNetworkProxy() const { return networkProxy; }
    QString getMediaPlayer() const { return mediaPlayer; }
    QString getDefaultSite() const { return defaultSite; }

signals:
    void youtubeDownloadQualityChanged(const QString &quality);
    void homescreenChanged();
    void defaultTransferStatusChanged();
    void transferPriorityChanged(const QString &priority);
    void pauseWhenMinimizedChanged();
    void monitorClipboardChanged(bool monitor);
    void playClipboardVideosChanged();
    void downloadClipboardVideosChanged();
    void downloadPathChanged(const QString &path);
    void safeSearchChanged();
    void recentSearchesChanged();
    void searchOrderChanged();
    void themeChanged();
    void activeColorChanged();
    void activeColorStringChanged();
    void gradientColorChanged();
    void gradientColorHighChanged();
    void languageChanged();
    void orientationChanged(const QString &orientation);
    void alert(const QString &message);
    void networkProxyChanged(const QString &proxy);
    void mediaPlayerChanged(const QString &player);
    void defaultSiteChanged();
    void youtubeUsernameChanged(const QString &user);
    void youtubeAccessTokenChanged(const QString &token);
    void dailymotionAccountChanged(const QString &user, const QString &aToken, const QString &rToken, int tokenExpiry);

public slots:
    void saveSettings();
    void restoreSettings();
    void setYouTubeDownloadQuality(const QString &quality);
    void setHomescreen(const QString &screen);
    void setDefaultTransferStatus(const QString &status);
    void setTransferPriority(const QString &priority);
    void setPauseWhenMinimized(bool pause);
    void setMonitorClipboard(bool monitor);
    void setPlayClipboardVideos(bool play);
    void setDownloadClipboardVideos(bool download);
    void setDownloadPath(const QString &path);
    void setSafeSearch(bool safe);
    void setRecentSearches(const QStringList &searches);
    void setSearchOrder(const QString &order);
    void setTheme(const QString &aTheme);
    void setActiveColor(const QString &color);
    void setActiveColorString(const QString &colorString);
    void setGradientColor(const QString &color);
    void setGradientColorHigh(const QString &color);
    void setLanguage(const QString &lang);
    void setOrientation(const QString &orientation);
    void setNetworkProxy(const QString &proxy);
    void setMediaPlayer(const QString &player);
    void setDefaultSite(const QString &site);
    void setYouTubeUsername(const QString &user);
    void setYouTubeAccessToken(const QString &token);
    void setDailymotionAccount(const QString &user, const QString &aToken, const QString &rToken, int tokenExpiry);
    QVariantList getLanguages() const;

private:
    QString youtubeDownloadQuality;
    QString homescreen;
    QString defaultTransferStatus;
    QString transferPriority;
    bool pauseWhenMinimized;
    bool monitorClipboard;
    bool playClipboardVideos;
    bool downloadClipboardVideos;
    QString downloadPath;
    bool safeSearch;
    QStringList recentSearches;
    QString searchOrder;
    QString theme;
    QString activeColor;
    QString activeColorString;
    QString gradientColor;
    QString gradientColorHigh;
    QString language;
    QString screenOrientation;
    QString networkProxy;
    QString mediaPlayer;
    QString defaultSite;
    QString youtubeUsername;
    QString youtubeAccessToken;
    QString dailymotionAccessToken;
    QString dailymotionRefreshToken;
    QString dailymotionUsername;
};

#endif // SETTINGS_H
