import QtQuick 1.0

Item {
    id: delegate

    property bool canBeClicked: true
    signal commentClicked(string author)

    width: delegate.ListView.view.width;
    height: authorText.height + commentText.height + 20

    Flow {
        id: authorText

        anchors { top: delegate.top; left: delegate.left; margins: 10 }
        width: parent.width
        height: 30

        Text {
            font.pixelSize: _SMALL_FONT_SIZE
            color: _TEXT_COLOR
            text: qsTr("By")
        }

        Text {
            font.pixelSize: _SMALL_FONT_SIZE
            color: (canBeClicked) && (author != YouTube.username) ? Settings.activeColor : _TEXT_COLOR
            text: " " + author + " "
            opacity: mouseArea.pressed ? 0.5 : 1
        }

        Text {
            font.pixelSize: _SMALL_FONT_SIZE
            color: _TEXT_COLOR
            text: qsTr("on") + " " + date.split("T")[0]
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: authorText
        onClicked: commentClicked(author)
        enabled: canBeClicked
    }

    Text {
        id: commentText

        width: delegate.width - 20
        anchors {top: authorText.bottom; left: authorText.left }
        wrapMode: TextEdit.WordWrap
        font.pixelSize: _SMALL_FONT_SIZE
        color: "#4d4d4d"
        text: comment.replace(/\r/g, "")
    }
}
