import QtQuick 1.0
import QtWebKit 1.0

Dialog {
    id: root

    function checkUrlForToken() {
        var url = webView.url.toString();
        if (/token=/i.test(url)) {
            var token = url.split("=").pop().replace(/\s|\n/, '');
            getYouTubeSessionToken(token);
        }
    }

    function getYouTubeSessionToken(tempToken) {
        busyDialog.show = true;
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var response = doc.responseText;
                if (/token/i.test(response)) {
                    var sessionToken = response.split("=")[1].split(/\s|\n/)[0];
                    saveYouTubeAccount(sessionToken);
                }
                else {
                    messages.displayMessage(qsTr("Unable to obtain YouTube session token"));
                }
                busyDialog.show = false;
                accept();
            }
        }
        doc.open("GET", "https://www.google.com/accounts/AuthSubSessionToken");
        doc.setRequestHeader("Authorization", "AuthSub token=" + tempToken);
        doc.send();
    }

    function saveYouTubeAccount(sessionToken) {
        Settings.setYouTubeUsername("");
        Settings.setYouTubeAccessToken(sessionToken);
    }

    titleText: qsTr("YouTube authorisation")
    content: Flickable {
        id: webFlicker

        anchors.fill: parent
        contentWidth: webView.width
        contentHeight: webView.height
        boundsBehavior: Flickable.DragOverBounds
        clip: true
        visible: webView.url != ""

        WebView {
            id: webView

            width: 1000
            height: 1000
            preferredWidth: parent.width
            preferredHeight: parent.height
            opacity:(status == WebView.Loading) || (webView.url.toString() == "") || (webView.url.toString().slice(0, 25) == "http://www.cutetube.co.uk") ? 0 : 1
            url: "https://www.google.com/accounts/AuthSubRequest?next=http://www.cutetube.co.uk&scope=http://gdata.youtube.com&session=1&secure=0"
            onUrlChanged: checkUrlForToken()

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 300 } }
        }
    }

    BusyDialog {
        id: busyDialog

        property bool show : false

        anchors.centerIn: parent
        visible: (busyDialog.show) || (webView.progress < 1)
    }
}
