import QtQuick 1.0

Page {
    id: root

    title: qsTr("Settings") + " - " + qsTr("Transfers")

    Flickable {
        id: flicker

        anchors { fill: parent; topMargin: titleArea.height }
        contentWidth: parent.width
        contentHeight: col1.height
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column {
            id: col1

            anchors { top: parent.top; left: parent.left; right: parent.right }
            spacing: 20

            SelectionItem {
                id: downloadStatusSelector

                title: qsTr("Start transfers")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("Automatically"); value: "queued" }
                    ListElement { name: QT_TR_NOOP("Manually"); value: "paused" }
                }
                initialValue: Settings.defaultTransferStatus
                onValueChosen: Settings.defaultTransferStatus = value
            }

            SelectionItem {
                id: transferPrioritySelector

                title: qsTr("Transfer priority")
                model: ListModel {
                    ListElement { name: QT_TR_NOOP("Uploads first"); value: "uploads" }
                    ListElement { name: QT_TR_NOOP("Downloads first"); value: "downloads" }
                }
                initialValue: Settings.transferPriority
                onValueChosen: Settings.transferPriority = value
            }
        }
    }
}
