import QtQuick 1.0

Rectangle {
    id: root

    property alias enabled: input.enabled
    property alias placeholderText: placeholderText.text
    property alias text : input.text
    property alias echoMode : input.echoMode
    property alias inputFocus: input.focus
    property int buttonMargin: 2

    height: 50
    color:  "white"
    border.width: 2
    border.color: input.activeFocus ? Settings.activeColor : "grey"
    radius: 5

    TextInput {
        id: input

        anchors { fill: parent; leftMargin: 2; rightMargin: buttonMargin; topMargin: 2; bottomMargin: 2 }
        font.pixelSize: _STANDARD_FONT_SIZE
        selectByMouse: true
        selectionColor: Settings.activeColor
    }

    Text {
        id: placeholderText

        anchors.fill: input
        font.pixelSize: _STANDARD_FONT_SIZE
        color: "#4d4d4d"
        clip: true
        visible: (!input.activeFocus) && (input.text == "")
    }
}
