import QtQuick 1.0

Rectangle {
    id: root

    property int maximumHeight: 200
    property alias enabled: textEdit.enabled
    property alias text: textEdit.text

    height: textEdit.height + 4
    color:  "white"
    border.width: 2
    border.color: textEdit.focus ? Settings.activeColor : "grey"
    radius: 5

    Flickable {
        anchors { fill: parent; margins: 2 }
        contentWidth: width
        contentHeight: textEdit.paintedHeight
        flickableDirection: Flickable.VerticalFlick
        boundsBehavior: Flickable.DragOverBounds
        clip: true

        TextEdit {
            id: textEdit

            height: paintedHeight < maximumHeight ? paintedHeight + 20 : maximumHeight
            width: parent.width
            font.pixelSize: _STANDARD_FONT_SIZE
            selectByMouse: true
            wrapMode: Text.WordWrap
            selectionColor: Settings.activeColor
        }
    }
}
