import QtQuick 1.0
import "scripts/dailymotion.js" as DM

Page {
    id: root

    property int topMargin: titleArea.height
    property bool error: false
    property variant user: []
    property bool isSubscribed

    function getUserProfile(id) {
        getProfile(id);
    }

    function checkIfSubscribed() {
        var i = 0;
        while ((!isSubscribed) && (i < dailymotionSubscriptionsModel.count)) {
            if (dailymotionSubscriptionsModel.get(i).id == user.id) {
                isSubscribed = true;
            }
            i++;
        }
    }

    function getWebProfile(url, id) {
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                try {
                    var results = doc.responseText.replace(/\s{2,}/g, " ");
                    var username = results.split("\"og:title\" content=\"")[1].split("\"")[0];
                    var avatar = results.split("\"og:image\" content=\"")[1].split("\"")[0];
                    var v = results.split("class=\"value\">")[1];
                    var views;
                    if (v) {
                        views = v.slice(0, v.indexOf("<"));
                    }
                    else {
                        views = "0";
                    }
                    var description = results.split("\"og:description\" content=\"")[1].split("\"")[0].replace(/&lt;br \/&gt;/g, "\n").replace(/&amp;/g, "&");
                    var about = results.split("id=\"user_details_cont\">")[1].split("<div class=\"dmco_clear\">")[0].split("\"dmco_text background_5\">");
                    var location = about[1].slice(0, about[1].indexOf("<"));
                    var registration = about[2].slice(0, about[2].indexOf("<"));
                    var online = ((about[3].slice(0, about[3].indexOf("<"))) == "Online Now");
                    var details = about[4].slice(0, about[4].indexOf("<")).split(", ");
                    var fans = details[0];
                    var favorites = details[1];
                    var comments = details[2];
                    user = { "id": id, "screenname": username, "avatar_large_url": avatar, "views": views,
                        "description": description, "location": location, "registration": registration,
                        "online": online, "fans": fans, "favorites": favorites, "comments": comments };
                    checkIfSubscribed();
                }
                catch(err) {
                    error = true;
                    messages.displayMessage(qsTr("Unable to retrieve profile"));
                    user = { "id": id };
                    checkIfSubscribed();
                }
            }
        }
        doc.open("GET", url);
        doc.send();
    }

    function getProfile(id) {
        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var results = eval("(" + doc.responseText + ")");
                getWebProfile(results.url, results.id);
            }
        }
        doc.open("GET", "https://api.dailymotion.com/user/" + id + "?fields=id,username,url");
        doc.send();
    }

    function showUploadDialog() {
        var uploadDialog = ObjectCreator.createObject(Qt.resolvedUrl("DMUploadDialog.qml"), appWindow);
        uploadDialog.open();
    }

    title: qsTr("Profile")

    Flickable {
        id: flicker

        anchors.fill: parent
        clip: true
        contentWidth: parent.width
        contentHeight: 200 + col1.height + col2.height
        flickableDirection: Flickable.VerticalFlick
        visible: (user.id) && (!error) ? true : false

        Text {
            id: titleText

            anchors { top: parent.top; left: parent.left; right: parent.right; margins: 10 }
            font.pixelSize: _STANDARD_FONT_SIZE
            font.bold: true
            color: _TEXT_COLOR
            wrapMode: Text.WordWrap
            text: !user.screenname ? "" : user.screenname
        }

        Image {
            id: cover

            width: 120
            height: 120
            anchors { left: titleText.left; top: titleText.bottom; topMargin: 10 }
            source: !user.avatar_large_url ? "" : user.avatar_large_url
            sourceSize.width: width
            sourceSize.height: height
            smooth: true
            onStatusChanged: if (status == Image.Error) source = "images/avatar.png";

            Image {
                width: 30
                height: 30
                anchors { bottom: parent.bottom; right: parent.right; margins: 5 }
                sourceSize.width: width
                sourceSize.height: height
                smooth: true
                source: !user.online ? "images/offline.png" : "images/online.png"
                visible: cover.source != "";
            }
        }

        Button {
            id: subscriptionButton

            anchors { right: parent.right; top: cover.bottom; margins: 10 }
            text: isSubscribed ? qsTr("Unsubscribe") : qsTr("Subscribe")
            visible: (Dailymotion.userSignedIn) && (user.id) && (user.id != Dailymotion.username) ? true : false
            onClicked: isSubscribed ? Dailymotion.unfollow(user.id) : Dailymotion.follow(user.id)
        }

        Column {
            id: col1

            anchors { left: cover.right; leftMargin: 10; top: cover.top; right: parent.right; rightMargin: 10 }

            Text {
                width: parent.width
                font.pixelSize: _STANDARD_FONT_SIZE
                color: _TEXT_COLOR
                elide: Text.ElideRight
                text: !user.views ? "" : user.views + " " + qsTr("views")
                visible: !(text == "")
            }

            Text {
                width: parent.width
                font.pixelSize: _STANDARD_FONT_SIZE
                elide: Text.ElideRight
                color: _TEXT_COLOR
                text: !user.fans ? "" : user.fans
                visible: !(text == "")
            }

            Text {
                width: parent.width
                font.pixelSize: _STANDARD_FONT_SIZE
                color: _TEXT_COLOR
                elide: Text.ElideRight
                text: !user.favorites ? "" : user.favorites
                visible: !(text == "")
            }

            Text {
                width: parent.width
                font.pixelSize: _STANDARD_FONT_SIZE
                color: _TEXT_COLOR
                elide: Text.ElideRight
                text: !user.comments ? "" : user.comments
                visible: !(text == "")
            }
        }

        Item {
            id: seperator

            height: 20
            anchors { left: parent.left; right: parent.right; top: subscriptionButton.visible ? subscriptionButton.bottom : cover.bottom; margins: 10 }

            Text {
                id: pText

                anchors { right: parent.right; top: parent.top }
                font.pixelSize: _SMALL_FONT_SIZE
                font.bold: true
                color: "#4d4d4d"
                horizontalAlignment: Text.AlignRight
                verticalAlignment: Text.AlignVCenter
                text: qsTr("Profile")
            }

            Rectangle {
                height: 1
                anchors { left: parent.left; right: pText.left; rightMargin: 10; verticalCenter: pText.verticalCenter }
                color: "#4d4d4d"
            }
        }

        Column {
            id: col2

            anchors { left: parent.left; right: parent.right; top: seperator.bottom; margins: 10 }

            Text {
                width: parent.width
                font.pixelSize: _STANDARD_FONT_SIZE
                color: _TEXT_COLOR
                text: !user.location ? "" : user.location
                visible: user.location ? true : false
            }

            Text {
                width: parent.width
                font.pixelSize: _STANDARD_FONT_SIZE
                color: _TEXT_COLOR
                text: !user.registration ? "" : user.registration
                visible: user.registration ? true : false
            }

            Text {
                width: parent.width
                font.pixelSize: _STANDARD_FONT_SIZE
                color: _TEXT_COLOR
                wrapMode: Text.WordWrap
                textFormat: Text.StyledText
                text: !user.description ? "" : user.description.replace(/\r/g, "")
                visible: user.description ? true : false
            }
        }
    }

    Text {
        id: noResultsText

        anchors.centerIn: flicker
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No profile found")
        visible: error
    }

    BusyDialog {
        anchors.centerIn: parent
        visible: !user.id ? true : false
    }
}
