import Qt 4.7
import "scripts/settings.js" as Settings
import "scripts/videolistscripts.js" as Scripts

Rectangle {
    id: window

    signal playVideos(variant videos)

    function onMenuButtonOneClicked() {
        /* Delete chosen videos from the archive */

        for (var i = 0; i < videoList.checkList.length; i++) {
            var video = archiveModel.get(videoList.checkList[i]);
            if (Settings.deleteVideoFromArchive(video.filePath)) {
                archiveModel.remove(videoList.checkList[i]);
                displayMessage(qsTr("Deleted from archive"));
            }
            else {
                displayMessage(qsTr("Unable to delete from archive"))
            }
        }
    }

    function onMenuButtonTwoClicked() {
        /* Delete chosen videos from both the archive and the device */

        for (var i = 0; i < videoList.checkList.length; i++) {
            var video = archiveModel.get(videoList.checkList[i]);
            if (Settings.deleteVideoFromArchive(video.filePath)) {
                Controller.deleteVideo(video.filePath);
                archiveModel.remove(videoList.checkList[i]);
            }
            else {
                displayMessage(qsTr("Unable to delete from archive"))
            }
        }
    }

    color: _BACKGROUND_COLOR

    Connections {
        target: Controller

        onAlert: displayMessage(message)
    }

    Item {
        id: dimmer

        anchors.fill: window

        Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

        Text {
            anchors.centerIn: dimmer
            font.pixelSize: _LARGE_FONT_SIZE
            font.bold: true
            color: "grey"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            text: "No videos in archive"
            visible: videoList.count == 0
        }

        ListView {
            id: videoList

            property variant checkList : []

            anchors { fill: dimmer; topMargin: 50 }
            snapMode: ListView.SnapToItem
            boundsBehavior: Flickable.DragOverBounds
            highlightMoveDuration: 500
            preferredHighlightBegin: 0
            preferredHighlightEnd: 100
            highlightRangeMode: ListView.StrictlyEnforceRange
            cacheBuffer: 2500
            interactive: visibleArea.heightRatio < 1

            Behavior on opacity { PropertyAnimation { properties: "opacity"; duration: 500 } }

            model: archiveModel

            onCountChanged: positionViewAtIndex(0, ListView.Beginning)

            delegate: ArchiveDelegate {
                id: delegate

                function addOrRemoveFromCheckList() {
                    var cl = videoList.checkList;
                    if (!delegate.checked) {
                        cl.push(index);
                    }
                    else {
                        for (var i = 0; i < cl.length; i++) {
                            if (cl[i] == index) {
                                cl.splice(i, 1);
                            }
                        }
                    }
                    videoList.checkList = cl;
                }

                Connections {
                    onDelegateClicked: Controller.playVideo(archiveModel.get(index).filePath) //playVideos([ archiveModel.get(index) ]);
                    onDelegatePressed: addOrRemoveFromCheckList()
                }

                checked: Scripts.indexInCheckList(index)
            }

            ScrollBar {}
        }

        MouseArea {
            id: mouseArea

            anchors { fill: dimmer; topMargin: 50 }
            enabled: false
        }

        states: State {
            name: "dim"
            PropertyChanges { target: dimmer; opacity: 0.3 }
        }

    }

    states: State {
        name: "portrait"
        when: window.height > window.width
    }
}
