import QtQuick 1.0

Item {
    id: delegate

    signal playClicked(string playerUrl)

    function getDuration(secs) {
        /* Converts seconds to HH:MM:SS format. */
        var hours = Math.floor(secs / 3600);
        var minutes = Math.floor(secs / 60) - (hours * 60);
        var seconds = secs - (hours * 3600) - ( minutes * 60);
        if (seconds < 10) {
            seconds = "0" + seconds;
        }
        var duration = minutes + ":" + seconds;
        if (hours > 0) {
            duration = hours + ":" + duration;
        }
        return duration;
    }

    width: delegate.ListView.view.width
    height: 80
    smooth: true

    Rectangle {
        anchors.fill: delegate
        color: _BACKGROUND_COLOR
        opacity: 0.5
    }

    Rectangle {
        id: highlight

        anchors.fill: parent
        gradient: Gradient {
            GradientStop { position: 0.0; color: _ACTIVE_COLOR_HIGH }
            GradientStop { position: 0.7; color: _ACTIVE_COLOR_LOW }
        }
        opacity: 0.7
        smooth: true
        visible: mouseArea.pressed
    }

    Text {
        id: titleText

        wrapMode: Text.WordWrap
        text: title
        color: _TEXT_COLOR
        font.pixelSize: _SMALL_FONT_SIZE
        anchors { left: frame.right; leftMargin: 5; right: delegate.right; rightMargin: 5; top: frame.top }
        verticalAlignment: Text.AlignTop
        smooth: true
        clip: true
    }

    Rectangle {
        id: frame

        z: 1
        width: 102
        height: 77
        anchors { left: delegate.left; leftMargin: 3; verticalCenter: delegate.verticalCenter }
        color: _BACKGROUND_COLOR
        border.width: 1
        border.color: "white"
        smooth: true

        Image {
            id: thumb

            anchors { fill: frame; margins: 1 }
            source: thumb.status == Image.Error ? "ui-images/error.jpg" : thumbnail
            smooth: true

            Rectangle {
                id: durationLabel

                width: 50
                height: 22
                anchors { bottom: thumb.bottom; right: thumb.right }
                color: "black"
                opacity: 0.5
                smooth: true
            }

            Text {
                anchors.fill: durationLabel
                text: getDuration(duration)
                color: "white"
                font.pixelSize: _SMALL_FONT_SIZE
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                smooth: true
            }
        }
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: _ACTIVE_COLOR_HIGH
        opacity: 0.5
        visible: !(index == delegate.ListView.view.count - 1)
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: playClicked(playerUrl)
    }
}
