#include "qmlapplicationviewer.h"
#include "controller.h"
#include "youtube.h"
#include "sharing.h"
#include "downloadmanager.h"
#include "folderlistmodel.h"
#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QtDeclarative>
#include <QStringList>

//#ifdef Q_WS_MAEMO_5
//#include <QtOpenGL/QGLWidget>
//#endif

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);   
    Controller ct;
    YouTube yt;

    QStringList args = app.arguments();
    args.takeFirst();
    if (args.isEmpty()) {

        QmlApplicationViewer viewer;

        QDeclarativeContext *context = viewer.rootContext();
        ct.setView(&viewer);
        Sharing sh;
        DownloadManager dm;
        QNetworkAccessManager *manager = new QNetworkAccessManager();
        yt.setNetworkAccessManager(manager);
        dm.setNetworkAccessManager(manager);
        sh.setNetworkAccessManager(manager);
        context->setContextProperty("Controller", &ct);
        context->setContextProperty("DownloadManager", &dm);
        context->setContextProperty("YouTube", &yt);
        context->setContextProperty("Sharing", &sh);

        qmlRegisterType<QDeclarativeFolderListModel>("Models",1,0,"FolderListModel");

    #ifdef Q_WS_MAEMO_5
        //    viewer.engine()->addImportPath(QString("/opt/qtm12/imports"));
        //    viewer.engine()->addPluginPath(QString("/opt/qtm12/plugins"));
        viewer.engine()->setOfflineStoragePath("/home/user/.config/cutetube");
        QDir path;
        path.setPath("/home/user/.config/cutetube");
        if (!path.exists()) {
            path.mkpath("/home/user/.config/cutetube");
        }
        path.setPath("/home/user/MyDocs/.cutetube");
        if (!path.exists()) {
            path.mkpath("/home/user/MyDocs/.cutetube");
        }
        //    viewer.setViewport(new QGLWidget());

        QString locale = ct.getLanguage();

        QTranslator translator;

        if (translator.load("/opt/usr/share/qmltube/qml/qmltube/i18n/qml_" + locale)) {
            app.installTranslator(&translator);
        }
    #endif

        viewer.setMainQmlFile(QLatin1String("qml/qmltube/main.qml"));
        viewer.showFullScreen();

        return app.exec();
    }

    else {
        /* Get the video URL and play the video */

        QString playerUrl = args.at(0);
        ct.getMediaPlayerFromDB();
        QObject::connect(&yt, SIGNAL(gotVideoUrl(QString)), &ct, SLOT(playVideo(QString)));
        QObject::connect(&yt, SIGNAL(videoUrlError()), &app, SLOT(quit()));
        QObject::connect(&ct, SIGNAL(playbackStarted()), &app, SLOT(quit()));
        yt.getVideoUrl(playerUrl);

        app.exec();
    }
}
