/* Video info functions */

function getDuration(secs) {
    /* Convert seconds to HH:MM:SS format. */

    var hours = Math.floor(secs / 3600);
    var minutes = Math.floor(secs / 60) - (hours * 60);
    var seconds = secs - (hours * 3600) - ( minutes * 60);
    if (seconds < 10) {
        seconds = "0" + seconds;
    }
    var duration = minutes + ":" + seconds;
    if (hours > 0) {
        duration = hours + ":" + duration;
    }
    return duration;
}

function showPlaylistDialog() {
    if (dimmer.state == "") {
        toggleControls(false);
        var playlistDialog = ObjectCreator.createObject("AddToPlaylistDialog.qml", window);
        playlistDialog.playlistClicked.connect(addVideoToPlaylist);
        playlistDialog.close.connect(closeDialogs);
        dimmer.state = "dim";
        playlistDialog.state = "show";
        mouseArea.enabled = true;
    }
}

function addVideoToPlaylist(playlistId) {
    YouTube.addToPlaylist(videoId, playlistId);
    closeDialogs();
}

function shareVideo(service) {
    if (dimmer.state == "") {
        toggleControls(false);
        if (service == "Twitter") {
            checkTwitterAccess(videoId);
        }
        else if (service == "Facebook") {
            checkFacebookAccess(videoId);
        }
    }
}

function showAddCommentDialog() {
    /* Add a new comment */

    if (dimmer.state == "") {
        toggleControls(false);
        var commentDialog = ObjectCreator.createObject("AddCommentDialog.qml", window);
        commentDialog.setService("YouTube", videoId);
        commentDialog.close.connect(closeDialogs);
        dimmer.state = "dim";
        commentDialog.state = "show";
        mouseArea.enabled = true;
    }
}

function closeDialogs() {
    /* Close any open dialogs and return the window to its default state */

    dialogClose();
    dimmer.state = "";
    mouseArea.enabled = false;
    toggleControls(true);
}

function checkFacebookAccess() {
    if (Sharing.facebookToken != "unknown") {
        var shareDialog = ObjectCreator.createObject("AddCommentDialog.qml", window);
        shareDialog.setService("Facebook", videoId);
        shareDialog.close.connect(closeDialogs);
        dimmer.state = "dim";
        shareDialog.state = "show";
        mouseArea.enabled = true;
    }
    else {
        getFacebookAccessToken();
    }
}

function getFacebookAccessToken() {
    var oauthDialog = ObjectCreator.createObject("OAuthDialog.qml", window);
    oauthDialog.setService("Facebook");
    oauthDialog.authorised.connect(checkFacebookAccess);
    oauthDialog.close.connect(closeDialogs);
    dimmer.state = "dim";
    oauthDialog.state = "show";
    mouseArea.enabled = true;
}
