import Qt 4.7

Item {
    id: dialog

    property string title : qsTr("Add Comment")
    property string videoId
    property string service

    signal close

    function setService(name, id) {
        dialog.service = name;
        if (name != "YouTube") {
            dialog.title = qsTr("Share Via ") + name;
        }
        dialog.videoId = id;
    }

    width: parent.width
    anchors { right: parent.left; top: parent.top; bottom: parent.bottom }

    Connections {
        target: dialog.parent

        onDialogClose: {
            dialog.state = "";
            dialog.destroy(600);
        }
    }

    Rectangle {
        id: background

        color: backgroundColor
        opacity: 0.5
        anchors.fill: dialog
    }

    Text {
        id: titleText

        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        text: title
        font.pixelSize: smallFontSize
        color: textColor
    }

    Rectangle {
        id: rect

        anchors { fill: dialog; leftMargin: 10; rightMargin: (dialog.parent.state == "") ? 180 : 10; topMargin: 50; bottomMargin: (dialog.parent.state == "") ? 10 : 100 }
        color:  "white"
        border.width: 2
        border.color: activeColorLow
        radius: 5

        TextEdit {
            id: commentEdit

            anchors { fill: rect; margins: 2 }
            focus: true
            font.pixelSize: standardFontSize
            selectByMouse: true
            wrapMode: Text.WordWrap
            selectionColor: activeColorLow
        }
    }

    PushButton {
        id: confirmButton

        width: (dialog.parent.state == "") ? 150 : dialog.width - 20
        anchors { right: dialog.right; bottom: dialog.bottom; margins: 10 }
        icon: "ui-images/tick.png"

        onButtonClicked: {
            if (dialog.service == "Facebook") {
                Sharing.postToFacebook(dialog.videoId, commentEdit.text);
            }
            else if (dialog.service == "Twitter") {
            }
            else {
                YouTube.addComment(dialog.videoId, commentEdit.text);
            }
            close();
        }
    }

    CloseButton {
        onButtonClicked: close()
    }

    MouseArea {

        property real xPos

        z: -1
        anchors.fill: dialog
        onPressed: xPos = mouseX
        onReleased: {
            if (xPos - mouseX > 100) {
                close();
            }
        }
    }

    states: State {
        name: "show"
        AnchorChanges { target: dialog; anchors.right: parent.right }
    }

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
    }
}
