import Qt 4.7

Item {
    id: delegate

    signal playClicked(string filePath)

    width: delegate.parent.width
    height: 80
    smooth: true

    Rectangle {
        anchors.fill: delegate
        color: _BACKGROUND_COLOR
        opacity: 0.5
    }

    ListHighlight {
        visible: mouseArea.pressed
    }

    Text {
        id: titleText

        wrapMode: Text.WordWrap
        text: title
        color: _TEXT_COLOR
        font.pixelSize: _SMALL_FONT_SIZE
        anchors { left: frame.right; leftMargin: 5; right: delegate.right; rightMargin: 5; top: frame.top; bottom: frame.bottom }
        verticalAlignment: Text.AlignTop
        smooth: true
        clip: true
    }

    Rectangle {
        id: frame

        z: 1
        width: 102
        height: 77
        anchors { left: delegate.left; leftMargin: 3; verticalCenter: delegate.verticalCenter }
        color: _BACKGROUND_COLOR
        border.width: 1
        border.color: "white"
        smooth: true

        Image {
            id: thumb

            anchors { fill: frame; margins: 1 }
            source: thumb.status == Image.Error ? "ui-images/error.jpg" : thumbnail
            smooth: true
        }
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: _ACTIVE_COLOR_HIGH
        opacity: 0.5
        visible: !(index == delegate.parent.count - 1)
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: playClicked(filePath)
    }
}
