#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QtDeclarative>
#include "qmlapplicationviewer.h"
#include "controller.h"
#include "youtube.h"
#include "qmaemo5homescreenadaptor.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    QmlApplicationViewer viewer;
    viewer.engine()->setOfflineStoragePath("/home/user/.config/cutetube");
    viewer.setStyleSheet("background:transparent");
    viewer.setAttribute(Qt::WA_TranslucentBackground);
    viewer.setMainQmlFile(QLatin1String("/opt/usr/share/qmltube-widget/qml/qmltube-widget/main.qml"));
    viewer.setFixedWidth(390);
    viewer.setFixedHeight(340);
    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&viewer);
    adaptor->setSettingsAvailable(false);
    Controller ct;
    YouTube yt;
    QDeclarativeContext *context = viewer.rootContext();
    context->setContextProperty("Controller", &ct);
    context->setContextProperty("YouTube", &yt);

    viewer.show();
    app.exec();
}
