#include "stationsmanagers.h"

StationsManagers::StationsManagers(QObject *parent) :
    QObject(parent)
{
    proxyModel = new QSortFilterProxyModel(this); //
    proxyModel->setDynamicSortFilter(true); //
    model = new ListModel(new RadioStation, qApp);
    populateModel();

    proxyModel->setSourceModel(model); //
    proxyModel->setFilterKeyColumn(-1); //

}

StationsManagers::~StationsManagers()
{
    saveModel();
}

void StationsManagers::clearModel()
{
}

QAbstractItemModel *StationsManagers::getModel()
{
    return proxyModel;
}

void StationsManagers::addStation(QString name, QString freq, QString favorite)
{
    bool addItem = true;
    for(int i = 0; i < model->rowCount(); ++i)
    {
       if((dynamic_cast<RadioStation*>(model->itemAt(i)))->freq() == freq)
           addItem = false;
    }

    if(addItem)
        model->appendRow(new RadioStation(name, freq, favorite, model));
}

void StationsManagers::deleteStation(int index)
{
    model->removeRow(index);
}

void StationsManagers::updateStation(int index, QString name, QString freq, QString favorite)
{
    index = proxyModel->mapToSource(proxyModel->index(index, 0)).row();
    RadioStation* station = dynamic_cast<RadioStation*>(model->itemAt(index));
    station->setValues(name, freq, favorite);
}

void StationsManagers::populateModel()
{
   // qDebug() << "in StationsManagers::populateModel()";
    QSettings settings;
    QStringList strings = settings.value("stations", QStringList()).toStringList();

    QStringList tempList;
    QString tempName;
    QString tempFreq;
    QString tempFav;

    for (int i = 0; i< strings.size(); i++)
    {
        tempList = strings.at(i).split("--");
        tempName = tempList.at(0);
        tempFreq = tempList.at(1);
        tempFav = tempList.at(2);

        model->appendRow(new RadioStation(tempName, tempFreq, tempFav));
    }
  // qDebug() << "out StationsManagers::populateModel()";
}

void StationsManagers::setFavoriteFilter(QString value)
{
    proxyModel->setFilterCaseSensitivity(Qt::CaseInsensitive);
    proxyModel->setFilterRole(RadioStation::FavoriteRole);
    proxyModel->setFilterWildcard(value);
}

void StationsManagers::moveStationUp(int index)
{
    if ( index == 0 ) return;

    QString name, freq, fav;
    RadioStation* radio = dynamic_cast<RadioStation*>(model->itemAt(index));
    name = radio->name();
    freq = radio->freq();
    fav = radio->favorite();

    model->removeRow(index);
    model->insertRow(index - 1, new RadioStation(name, freq, fav));
}

void StationsManagers::moveStationDown(int index)
{
    if ( index == model->rowCount() -1 ) return;

    QString name, freq, fav;
    RadioStation* radio = dynamic_cast<RadioStation*>(model->itemAt(index));
    name = radio->name();
    freq = radio->freq();
    fav = radio->favorite();

    model->removeRow(index);
    model->insertRow(index + 1, new RadioStation(name, freq, fav));
}

void StationsManagers::saveModel()
{
    QSettings settings;

    RadioStation* tempRadio;
    QStringList tempList;
    QString tempName, tempFreq, tempFav;

    for (int i=0; i<model->rowCount(); i++)
    {
        tempRadio = dynamic_cast<RadioStation*>(model->itemAt(i));
        tempName = tempRadio->name();
        tempFreq = tempRadio->freq();
        tempFav = tempRadio->favorite();

        tempList.append(  QString("%1--%2--%3").arg(tempName).arg(tempFreq).arg(tempFav)  );
    }

    settings.setValue("stations", tempList);
}
