import QtQuick 1.1

Rectangle {
    id: screen
    width: isRealPortrait ? 480 : 800
    height: isRealPortrait ? 800 : 480
    color: "black"

    Item {
        id: rotatorItem
        width: isPortrait ? 480 : 800
        height: isPortrait ? 800 : 480
        anchors.centerIn: parent
        rotation: {
            if (isRealPortrait == isPortrait)
                return 0
            else if (!isRealPortrait && isPortrait)
                return -90
            else if (isRealPortrait && !isPortrait)
                return 90
        }
        MainPage {
            id: mainPage
        }
        FontLoader {
            id: digital7Font
            source: "../font/digital-7.ttf"
        }
        SettingsPage {
            id: settingsPage
        }
    }

}

