// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item {
    id: root
    clip: true

    property alias listView: stationsView
    property bool editMode: false

//    Rectangle {
//        anchors.fill: parent
//        color: "black"
//        opacity: 0.3
//    }

    Rectangle{
        z: 100
        opacity: 0.3
        color: "black"
        visible: isHildon ? (fmRadio.active ? false : true) : false
        anchors.fill: parent
        MouseArea {
            anchors.fill: parent
        }
    }

    AddStationSheet {
        id: addStationSheet
        visible: false
    }

//    Bar {
//        id: stationsBar
//        text: "Stations"
//    }

    ListView {
        id: stationsView
        anchors.top: parent.top
        anchors.topMargin: 60
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.bottom: toolBar.top

        clip: true

        model: stationsModel

        highlight: Rectangle {
            width: root.width
            height: 70
            z: -50
            gradient: Gradient {
                GradientStop {
                    position: 0
                    color: "#00ffffff"
                }
                GradientStop {
                    position: 0.3
                    color: "#55ffffff"
                }
                GradientStop {
                    position: 0.99
                    color: "#00ffffff"
                }
            }
        }

        delegate: Item {
            id: delegateItem
            width: root.width
            height: 70

            property variant myData: model

            Label {
                anchors.verticalCenter: delegateItem.verticalCenter
                anchors.left: parent.left
                anchors.leftMargin: 10

                text: index + 1
            }
            Label {
                anchors.verticalCenter: delegateItem.verticalCenter
                anchors.left: parent.left
                anchors.leftMargin: 50

                text: name
            }

            Label {
                visible: !editMode
                anchors.verticalCenter: delegateItem.verticalCenter
                anchors.right: parent.right
                anchors.rightMargin: 15

                text: freq
            }

            MouseArea {
                id: mouseArea
                anchors.fill: parent
                onClicked: {
                    //                    GlobalJS.currentStation = listView.currentItem.myData.name
                    //console.log("station clicked")

                    //radioPage.test()
                    mainPage.currentListIndex = index
                    fmRadio.freq = freq
                }
            }



            QuickAccessButton {
                id: headphones
                height: 40
                visible: !editMode && (fmRadio.freq == freq)
                anchors.right: parent.right
                anchors.verticalCenter: parent.verticalCenter
                anchors.rightMargin: 150
                border.color: "white"
            }
            Image {
                visible: headphones.visible
                source: "file:/" + appPath + "/images/icon-m-toolbar-headphones.svg"
                anchors.centerIn: headphones
            }

            QuickAccessButton {
                id: removeIcon1
                visible: editMode
                height: 50
                width: height + 10
                anchors.verticalCenter: parent.verticalCenter
                anchors.rightMargin: 10
                anchors.right: parent.right
                enabled: editMode
                border.color: "white"
                onClicked: {
                    stationsManager.deleteStation(index)
                }
            }
            Image {
                visible: removeIcon1.visible
                source: "file:/" + appPath + "/images/icon-m-toolbar-stop.svg"
                anchors.centerIn: removeIcon1
            }

            QuickAccessButton {
                id: moveUpIcon1
                height: 50
                width: height + 10
                visible: editMode
                enabled: editMode
                anchors.verticalCenter: parent.verticalCenter
                anchors.right: removeIcon1.left
                anchors.rightMargin: 10
                border.color: "white"
                onClicked: {
                    stationsManager.moveStationUp(index)
                }
            }
            Image {
                source: "file:/" + appPath + "/images/icon-s-status-menu-open.svg"
                rotation: 180
                anchors.horizontalCenter: moveUpIcon1.horizontalCenter
                anchors.top: moveUpIcon1.top
                anchors.topMargin: 12
                visible: moveUpIcon1.visible
            }
            QuickAccessButton {
                id: moveDownIcon1
                height: 50
                width: height + 10
                visible: editMode
                enabled: editMode
                anchors.verticalCenter: parent.verticalCenter
                anchors.right: moveUpIcon1.left
                anchors.rightMargin: 10
                border.color: "white"
                onClicked: {
                    stationsManager.moveStationDown(index)
                }
            }
            Image {
                source: "file:/" + appPath + "/images/icon-s-status-menu-open.svg"
                anchors.horizontalCenter: moveDownIcon1.horizontalCenter
                anchors.top: moveDownIcon1.top
                anchors.topMargin: 20
                visible: moveDownIcon1.visible
            }
            QuickAccessButton {
                id: favoriteIcon1
                height: 50
                width: height + 10
                visible: editMode
                enabled: editMode
                anchors.verticalCenter: parent.verticalCenter
                anchors.right: moveDownIcon1.left
                anchors.rightMargin: 10
                border.color: "white"
                onClicked: {
                    stationsManager.updateStation(
                                index, name, freq,
                                favorite == "true" ? "false" : "true")
                }
            }
            Image {
                source: favorite
                        == "true" ? "file:/" + appPath
                                    + "/images/icon-s-toolbar-favorite-mark.svg" : "file:/"
                                    + appPath + "/images/icon-s-toolbar-favorite-unmark.svg"
                anchors.centerIn: favoriteIcon1
                visible: favoriteIcon1.visible
            }

            QuickAccessButton {
                id: editIcon
                visible: editMode
                height: 50
                width: height + 10
                anchors.verticalCenter: parent.verticalCenter
                anchors.rightMargin: 10
                anchors.right: favoriteIcon1.left
                enabled: editMode
                border.color: "white"
                onClicked: {
                    addStationSheet.editMode = true
                    addStationSheet.fave = favorite
                    addStationSheet.indexe = index
                    addStationSheet.stationName = myData.name
                    addStationSheet.visible = true
                }
            }
            Rectangle {
                id: r1
                width: 24
                height: 4
                radius: 7
                color: "#b9b9b9"
                anchors.centerIn: editIcon
                visible: editIcon.visible
            }
            Rectangle {
                width: r1.width
                height: r1.height
                radius: r1.radius
                color: r1.color
                anchors.horizontalCenter: editIcon.horizontalCenter
                anchors.bottom: r1.top
                anchors.bottomMargin: 4
                visible: editIcon.visible
            }
            Rectangle {
                width: r1.width
                height: r1.height
                radius: r1.radius
                color: r1.color
                anchors.horizontalCenter: editIcon.horizontalCenter
                anchors.top: r1.bottom
                anchors.topMargin: 4
                visible: editIcon.visible
            }

            Rectangle {
                width: root.width - 20
                anchors.horizontalCenter: parent.horizontalCenter
                height: 2
                color: "gray"
                anchors.top: parent.top
                visible: index !== 0
            }
        }

        onCountChanged: currentListCount = count
        Component.onCompleted: currentListCount = count
    }

    Rectangle {
        anchors.fill: toolBar
        opacity: 0.3
        color: "#55000000"
        radius: 4
//        gradient: Gradient {
//            GradientStop {
//                position: 0
//                color: "#55000000"
//            }
//            GradientStop {
//                position: 0.3
//                color: "#dd333333"
//            }
//            GradientStop {
//                position: 0.99
//                color: "#55000000"
//            }
//        }
    }

    Item {
        id: toolBar
        width: parent.width
        height: 74
        anchors.bottom: parent.bottom
        property bool filterActive: false
        QuickAccessButton {
            id: plus
            anchors.left: parent.left
            anchors.leftMargin: 2
            height: 50
            //anchors.verticalCenter: parent.verticalCenter
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 8
            border.color: "white"
            onClicked: {
                addStationSheet.editMode = false
                addStationSheet.stationName = fmRadio.ps
                addStationSheet.visible = true

                console.log("add station")
            }
        }
        Image {
            anchors.centerIn: plus
            source: "file:/" + appPath + "/images/plus.png"
        }
        QuickAccessButton {
            id: option
            anchors.horizontalCenter: parent.horizontalCenter
            //anchors.verticalCenter: parent.verticalCenter
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 8
            height: 50
            border.color: "white"
            onClicked: editMode = !editMode
        }
        Rectangle {
            id: r1
            width: 24
            height: 4
            radius: 7
            color: "#b9b9b9"
            anchors.centerIn: option
        }
        Rectangle {
            width: r1.width
            height: r1.height
            radius: r1.radius
            color: r1.color
            anchors.horizontalCenter: option.horizontalCenter
            anchors.bottom: r1.top
            anchors.bottomMargin: 4
        }
        Rectangle {
            width: r1.width
            height: r1.height
            radius: r1.radius
            color: r1.color
            anchors.horizontalCenter: option.horizontalCenter
            anchors.top: r1.bottom
            anchors.topMargin: 4
        }
        QuickAccessButton {
            id: favorite
            anchors.right: parent.right
            ///anchors.verticalCenter: parent.verticalCenter
            anchors.rightMargin: 2
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 8
            height: 50
            border.color: "white"
            onClicked: {
                stationsManager.setFavoriteFilter(
                            toolBar.filterActive ? "" : "true")
                toolBar.filterActive = !toolBar.filterActive
            }
        }
        Image {
            anchors.centerIn: favorite
            source: toolBar.filterActive ? "file:/" + appPath
                                           + "/images/icon-s-toolbar-favorite-mark.svg" : "file:/"
                                           + appPath + "/images/fav-unmark.png"
        }
    }

    Connections {
        target: mainPage
        onCurrentListIndexChanged: {
           // console.debug("index changed")
            listView.currentIndex = mainPage.currentListIndex
            fmRadio.freq = listView.currentItem.myData.freq
        }
    }
}
