﻿// Version 0.0.1
import QtQuick 1.1

Item {
    id: root

    //width: screen.inPortrait ? screen.displayHeight : screen.displayWidth
    height: 72

    property alias text: headerLabel.text
    property alias textColor: headerLabel.color
    property bool showMenuIcon: false
    property bool clickable: false
    property bool showBorder: true

    signal clicked()

    Rectangle {
        id: headerRect
        anchors.fill: parent
        gradient: Gradient {
            GradientStop { position: 0; color: mouseArea.pressed ? "#222" : "#111" }
            GradientStop { position: 0.3; color: mouseArea.pressed ? "#444" : "#222" }
            GradientStop { position: 0.6; color: mouseArea.pressed ? "#666" : "#444" }
            GradientStop { position: 1.0; color: mouseArea.pressed ? "#222" : "#111" }
        }
    }

    Rectangle {
        anchors.fill: parent
        visible: root.showBorder
        color: "transparent"
        border.color: "black"
    }


    Label {
        id: headerLabel
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: parent.left
        anchors.leftMargin: 20
        //font.pixelSize: 30
        color: "white"
    }

//    ToolIcon {
//        id: menuIcon
//        visible: root.showMenuIcon
//        platformIconId: "toolbar-view-menu"
//        anchors.right: root.right
//        anchors.verticalCenter: root.verticalCenter
//        onClicked: (myMenu.status == DialogStatus.Closed) ? myMenu.open() : myMenu.close()
//    }

    MouseArea {
        id: mouseArea
        enabled: root.clickable
        anchors.fill: root
        onClicked: {
            root.clicked()
        }
    }
}
